/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.IOHandler;
import org.hypertable.AsyncComm.IOHandlerData;
import org.hypertable.AsyncComm.RequestCache;

class Reactor
implements Runnable {
    final Selector selector;
    final long EVENT_LOOP_TIMEOUT_MS = 5000L;
    static final Logger log = Logger.getLogger("org.hypertable");
    LinkedList<IOHandler> pending = new LinkedList();
    private RequestCache mRequestCache = new RequestCache();
    private boolean mShutdown = false;

    Reactor() throws IOException {
        this.selector = Selector.open();
    }

    public Selector GetSelector() {
        return this.selector;
    }

    public synchronized void AddToRegistrationQueue(IOHandler handler) {
        this.pending.add(handler);
    }

    public void WakeUp() {
        this.selector.wakeup();
    }

    public void Shutdown() {
        this.mShutdown = true;
        this.selector.wakeup();
    }

    private synchronized void DoRegistrations() {
        while (!this.pending.isEmpty()) {
            IOHandler handler = this.pending.removeFirst();
            handler.Register(this.selector);
        }
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.selector.select(5000L);
                if (this.mShutdown) {
                    return;
                }
                this.DoRegistrations();
                Set<SelectionKey> selected = this.selector.selectedKeys();
                for (SelectionKey selkey : selected) {
                    IOHandler handler = (IOHandler)selkey.attachment();
                    handler.run(selkey);
                }
                selected.clear();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void AddRequest(int id, IOHandlerData handler, DispatchHandler dh, long expire) {
        this.mRequestCache.Insert(id, handler, dh, expire);
    }

    DispatchHandler RemoveRequest(int id) {
        RequestCache.CacheNode node = this.mRequestCache.Remove(id);
        if (node != null) {
            return node.dh;
        }
        return null;
    }

    void HandleTimeouts() {
        RequestCache.CacheNode node;
        long now = System.currentTimeMillis();
        while ((node = this.mRequestCache.GetNextTimeout(now)) != null) {
            node.handler.DeliverEvent(new Event(Event.Type.ERROR, node.handler.GetAddress(), 65541), node.dh);
        }
    }

    void CancelRequests(IOHandlerData handler) {
        this.mRequestCache.PurgeRequests(handler);
    }
}

