/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hypertable.AsyncComm.Reactor;

public class ReactorFactory {
    private static AtomicInteger nexti = new AtomicInteger(0);
    private static Reactor[] reactors;

    public static void Initialize(short count) throws IOException {
        reactors = new Reactor[count];
        for (int i = 0; i < count; ++i) {
            ReactorFactory.reactors[i] = new Reactor();
            Thread thread = new Thread((Runnable)reactors[i], "Reactor " + i);
            thread.setPriority(10);
            thread.start();
        }
    }

    public static void Shutdown() {
        for (int i = 0; i < reactors.length; ++i) {
            reactors[i].Shutdown();
        }
    }

    public static Reactor Get() {
        return reactors[nexti.getAndIncrement() % reactors.length];
    }
}

