/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class Serialization {
    public static int EncodedLengthByteArray(int len) {
        return len + 4;
    }

    public static void EncodeByteArray(ByteBuffer buf, byte[] data, int len) {
        buf.putInt(len);
        buf.put(data, 0, len);
    }

    public static byte[] DecodeByteArray(ByteBuffer buf) {
        if (buf.remaining() < 4) {
            return null;
        }
        int len = buf.getInt();
        byte[] rbytes = new byte[len];
        if (len > 0) {
            buf.get(rbytes, 0, len);
        }
        return rbytes;
    }

    public static int EncodedLengthString(String str) {
        if (str == null) {
            return 3;
        }
        try {
            return 3 + str.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(-1);
            return 0;
        }
    }

    public static void EncodeString(ByteBuffer buf, String str) {
        try {
            short len = str == null ? (short)0 : (short)str.getBytes("UTF-8").length;
            buf.putShort(len);
            if (len > 0) {
                buf.put(str.getBytes("UTF-8"));
            }
            buf.put((byte)0);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static String DecodeString(ByteBuffer buf) {
        if (buf.remaining() < 3) {
            return null;
        }
        short len = buf.getShort();
        if (len == 0) {
            buf.get();
            return new String("");
        }
        byte[] sbytes = new byte[len];
        buf.get(sbytes);
        buf.get();
        try {
            return new String(sbytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }
}

