/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.Common;

import java.io.File;
import java.io.IOException;
import org.hypertable.Common.FileUtils;
import org.hypertable.Common.Usage;

public class Checksum {
    static String[] usage = new String[]{"", "usage: java org.hypertable.Common.Checksum <algorithm> <file>", "", "This program runs the checksum algorithm, <algorithm>, over the bytes", "of the input file <file> and displays the resulting checksum as a", "signed integer.", "", "Supported Algorithms:", "", "  fletcher32", "", null};

    public static int fletcher32(byte[] data, int offset, int len) {
        int datai = offset;
        int sum1 = 65535;
        int sum2 = 65535;
        int len16 = len / 2;
        while (len16 != 0) {
            int tlen = len16 > 360 ? 360 : len16;
            len16 -= tlen;
            if (tlen != 0) {
                do {
                    sum2 += (sum1 += (short)(data[datai] & 0xFF) << 8 | (short)(data[datai + 1] & 0xFF));
                    datai += 2;
                } while (--tlen != 0);
            }
            sum1 = (sum1 & 0xFFFF) + (sum1 >> 16);
            sum2 = (sum2 & 0xFFFF) + (sum2 >> 16);
        }
        if ((len & 1) != 0) {
            short rem = (short)(data[datai] & 0xFF);
            rem = (short)(rem << 8);
            sum2 += (sum1 += rem);
            sum1 = (sum1 & 0xFFFF) + (sum1 >> 16);
            sum2 = (sum2 & 0xFFFF) + (sum2 >> 16);
        }
        sum1 = (sum1 & 0xFFFF) + (sum1 >> 16);
        sum2 = (sum2 & 0xFFFF) + (sum2 >> 16);
        return sum2 << 16 | sum1;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            Usage.DumpAndExit(usage);
        }
        if (args[0].equals("fletcher32")) {
            byte[] data = FileUtils.FileToBuffer(new File(args[1]));
            int checksum = Checksum.fletcher32(data, 0, data.length);
            System.out.println(checksum);
        } else {
            Usage.DumpAndExit(usage);
        }
    }
}

