/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.DfsBroker.hadoop;

import java.util.logging.Logger;
import org.hypertable.AsyncComm.ApplicationHandler;
import org.hypertable.AsyncComm.ApplicationQueue;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.ResponseCallback;
import org.hypertable.DfsBroker.hadoop.HdfsBroker;
import org.hypertable.DfsBroker.hadoop.OpenFileMap;
import org.hypertable.DfsBroker.hadoop.RequestHandlerClose;
import org.hypertable.DfsBroker.hadoop.RequestHandlerCreate;
import org.hypertable.DfsBroker.hadoop.RequestHandlerExists;
import org.hypertable.DfsBroker.hadoop.RequestHandlerFlush;
import org.hypertable.DfsBroker.hadoop.RequestHandlerLength;
import org.hypertable.DfsBroker.hadoop.RequestHandlerMkdirs;
import org.hypertable.DfsBroker.hadoop.RequestHandlerOpen;
import org.hypertable.DfsBroker.hadoop.RequestHandlerPositionRead;
import org.hypertable.DfsBroker.hadoop.RequestHandlerRead;
import org.hypertable.DfsBroker.hadoop.RequestHandlerReaddir;
import org.hypertable.DfsBroker.hadoop.RequestHandlerRemove;
import org.hypertable.DfsBroker.hadoop.RequestHandlerRename;
import org.hypertable.DfsBroker.hadoop.RequestHandlerRmdir;
import org.hypertable.DfsBroker.hadoop.RequestHandlerSeek;
import org.hypertable.DfsBroker.hadoop.RequestHandlerShutdown;
import org.hypertable.DfsBroker.hadoop.RequestHandlerStatus;
import org.hypertable.DfsBroker.hadoop.RequestHandlerWrite;

public class ConnectionHandler
implements DispatchHandler {
    static final Logger log = Logger.getLogger("org.hypertable.DfsBroker.hadoop");
    private Comm mComm;
    private ApplicationQueue mAppQueue;
    private HdfsBroker mBroker;

    public ConnectionHandler(Comm comm, ApplicationQueue appQueue, HdfsBroker broker) {
        this.mComm = comm;
        this.mAppQueue = appQueue;
        this.mBroker = broker;
    }

    @Override
    public void handle(Event event) {
        if (event.type == Event.Type.MESSAGE) {
            ApplicationHandler requestHandler;
            switch ((int)event.header.command) {
                case 0: {
                    requestHandler = new RequestHandlerOpen(this.mComm, this.mBroker, event);
                    break;
                }
                case 2: {
                    requestHandler = new RequestHandlerClose(this.mComm, this.mBroker, event);
                    break;
                }
                case 1: {
                    requestHandler = new RequestHandlerCreate(this.mComm, this.mBroker, event);
                    break;
                }
                case 8: {
                    requestHandler = new RequestHandlerLength(this.mComm, this.mBroker, event);
                    break;
                }
                case 3: {
                    requestHandler = new RequestHandlerRead(this.mComm, this.mBroker, event);
                    break;
                }
                case 4: {
                    requestHandler = new RequestHandlerWrite(this.mComm, this.mBroker, event);
                    break;
                }
                case 5: {
                    requestHandler = new RequestHandlerSeek(this.mComm, this.mBroker, event);
                    break;
                }
                case 6: {
                    requestHandler = new RequestHandlerRemove(this.mComm, this.mBroker, event);
                    break;
                }
                case 9: {
                    requestHandler = new RequestHandlerPositionRead(this.mComm, this.mBroker, event);
                    break;
                }
                case 10: {
                    requestHandler = new RequestHandlerMkdirs(this.mComm, this.mBroker, event);
                    break;
                }
                case 7: {
                    requestHandler = new RequestHandlerShutdown(this.mComm, this.mAppQueue, this.mBroker, event);
                    break;
                }
                case 11: {
                    requestHandler = new RequestHandlerStatus(this.mComm, this.mAppQueue, event);
                    break;
                }
                case 12: {
                    requestHandler = new RequestHandlerFlush(this.mComm, this.mBroker, event);
                    break;
                }
                case 13: {
                    requestHandler = new RequestHandlerRmdir(this.mComm, this.mBroker, event);
                    break;
                }
                case 14: {
                    requestHandler = new RequestHandlerReaddir(this.mComm, this.mBroker, event);
                    break;
                }
                case 15: {
                    requestHandler = new RequestHandlerExists(this.mComm, this.mBroker, event);
                    break;
                }
                case 16: {
                    requestHandler = new RequestHandlerRename(this.mComm, this.mBroker, event);
                    break;
                }
                default: {
                    ResponseCallback cb = new ResponseCallback(this.mComm, event);
                    log.severe("Command code " + event.header.command + " not implemented");
                    cb.error(1, "Command code " + event.header.command + " not implemented");
                    return;
                }
            }
            this.mAppQueue.Add(requestHandler);
        } else if (event.type == Event.Type.DISCONNECT) {
            log.info(event.toString() + " : Closing all open handles from " + event.addr);
            OpenFileMap ofMap = this.mBroker.GetOpenFileMap();
            ofMap.RemoveAll(event.addr);
        } else {
            log.info(event.toString());
        }
    }
}

