/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.DfsBroker.hadoop;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hypertable.DfsBroker.hadoop.OpenFileData;

public class OpenFileMap {
    private HashMap<Integer, OpenFileData> mFileMap = new HashMap();

    public synchronized OpenFileData Create(int fd, InetSocketAddress addr) {
        OpenFileData ofd = new OpenFileData();
        ofd.addr = addr;
        this.mFileMap.put(fd, ofd);
        return ofd;
    }

    public synchronized OpenFileData Get(int fd) {
        return this.mFileMap.get(fd);
    }

    public synchronized OpenFileData Remove(int fd) {
        return this.mFileMap.remove(fd);
    }

    public synchronized void RemoveAll(InetSocketAddress addr) {
        int icount = 0;
        int ocount = 0;
        Iterator<Map.Entry<Integer, OpenFileData>> iter = this.mFileMap.entrySet().iterator();
        while (iter.hasNext()) {
            try {
                Map.Entry<Integer, OpenFileData> entry = iter.next();
                int id = entry.getKey();
                OpenFileData ofd = entry.getValue();
                if (!ofd.addr.equals(addr)) continue;
                if (ofd.os != null) {
                    ofd.os.close();
                    ++ocount;
                }
                if (ofd.is != null) {
                    ofd.is.close();
                    ++icount;
                }
                iter.remove();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        System.out.println("Closed " + icount + " input streams and " + ocount + " output streams for client connection " + addr);
    }

    public synchronized void RemoveAll() {
        int icount = 0;
        int ocount = 0;
        Iterator<Map.Entry<Integer, OpenFileData>> iter = this.mFileMap.entrySet().iterator();
        while (iter.hasNext()) {
            try {
                Map.Entry<Integer, OpenFileData> entry = iter.next();
                int id = entry.getKey();
                OpenFileData ofd = entry.getValue();
                if (ofd.os != null) {
                    ofd.os.close();
                    ++ocount;
                }
                if (ofd.is != null) {
                    ofd.is.close();
                    ++icount;
                }
                iter.remove();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.mFileMap.clear();
        System.out.println("Closed " + icount + " input streams and " + ocount + " output streams");
    }
}

