/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.DfsBroker.hadoop;

import java.net.ProtocolException;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.ApplicationHandler;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.ResponseCallback;
import org.hypertable.AsyncComm.Serialization;
import org.hypertable.Common.Error;
import org.hypertable.DfsBroker.hadoop.HdfsBroker;

public class RequestHandlerRename
extends ApplicationHandler {
    static final Logger log = Logger.getLogger("org.hypertable.DfsBroker.hadoop");
    private Comm mComm;
    private HdfsBroker mBroker;

    public RequestHandlerRename(Comm comm, HdfsBroker broker, Event event) {
        super(event);
        this.mComm = comm;
        this.mBroker = broker;
    }

    @Override
    public void run() {
        block3: {
            ResponseCallback cb = new ResponseCallback(this.mComm, this.mEvent);
            try {
                String dst;
                String src = Serialization.DecodeString(this.mEvent.payload);
                if (src == null || (dst = Serialization.DecodeString(this.mEvent.payload)) == null) {
                    throw new ProtocolException("Error decoding filenames");
                }
                this.mBroker.Rename(cb, src, dst);
            }
            catch (ProtocolException e) {
                int error = cb.error(1, e.getMessage());
                log.severe("Protocol error (Rename) - " + e.getMessage());
                if (error == 0) break block3;
                log.severe("Problem sending (Rename) error back to client - " + Error.GetText(error));
            }
        }
    }
}

