/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.DfsBroker.hadoop;

import java.net.ProtocolException;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.ApplicationHandler;
import org.hypertable.AsyncComm.ApplicationQueue;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.ResponseCallback;
import org.hypertable.Common.Error;
import org.hypertable.DfsBroker.hadoop.HdfsBroker;

public class RequestHandlerShutdown
extends ApplicationHandler {
    static final Logger log = Logger.getLogger("org.hypertable.DfsBroker.hadoop");
    private Comm mComm;
    private ApplicationQueue mAppQueue;
    private HdfsBroker mBroker;

    public RequestHandlerShutdown(Comm comm, ApplicationQueue appQueue, HdfsBroker broker, Event event) {
        super(event);
        this.mComm = comm;
        this.mAppQueue = appQueue;
        this.mBroker = broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResponseCallback cb = new ResponseCallback(this.mComm, this.mEvent);
        try {
            if (this.mEvent.payload.remaining() < 2) {
                throw new ProtocolException("Truncated message");
            }
            this.mAppQueue.Shutdown();
            this.mBroker.GetOpenFileMap().RemoveAll();
            short flags = this.mEvent.payload.getShort();
            if ((flags & 1) != 0) {
                log.info("Immediate shutdown.");
                System.exit(0);
            }
            cb.response_ok();
            RequestHandlerShutdown requestHandlerShutdown = this;
            synchronized (requestHandlerShutdown) {
                this.wait(2000L);
            }
            System.exit(0);
        }
        catch (ProtocolException e) {
            int error = cb.error(1, e.getMessage());
            log.severe("Protocol error (SHUTDOWN) - " + e.getMessage());
            if (error != 0) {
                log.severe("Problem sending (SHUTDOWN) error back to client - " + Error.GetText(error));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

