/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.DfsBroker.hadoop;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.hadoop.fs.FileSystem;
import org.hypertable.AsyncComm.ApplicationQueue;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.ConnectionHandlerFactory;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.ReactorFactory;
import org.hypertable.Common.Usage;
import org.hypertable.DfsBroker.hadoop.ConnectionHandler;
import org.hypertable.DfsBroker.hadoop.HdfsBroker;

public class main {
    static final Logger log = Logger.getLogger("org.hypertable.DfsBroker.hadoop");
    static String[] usage = new String[]{"", "usage: java org.hypertable.DfsBroker.hadoop.main [OPTIONS]", "", "OPTIONS:", "  --help           Display this help text and exit", "  --config=<file>  Load configuration properties from <file>", "  --verbose        Generate verbose logging output", "", "This program brokers Hadoop Distributed Filesystem (HDFS) requests", "on behalf of remote clients.  It is intended to provide an efficient", "way for C++ programs to use HDFS.", "", null};
    static final int DEFAULT_PORT = 38030;
    static final short DEFAULT_WORKERS = 20;
    private static HdfsBroker ms_broker;
    private static ApplicationQueue ms_app_queue;

    public static void main(String[] args) throws IOException, InterruptedException {
        int workerCount;
        String str;
        String configFile = null;
        Properties props = new Properties();
        boolean verbose = false;
        if (args.length == 1 && args[0].equals("--help")) {
            Usage.DumpAndExit(usage);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--config=")) {
                configFile = args[i].substring(9);
                continue;
            }
            if (args[i].equals("--verbose")) {
                verbose = true;
                continue;
            }
            Usage.DumpAndExit(usage);
        }
        ShutdownHook sh = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(sh);
        if (configFile == null) {
            configFile = org.hypertable.Common.System.installDir + "/conf/hypertable.cfg";
        }
        FileInputStream fis = new FileInputStream(configFile);
        props.load(fis);
        if (verbose) {
            props.setProperty("verbose", "true");
        }
        int port = 38030;
        if (props.contains("DfsBroker.Port")) {
            str = props.getProperty("DfsBroker.Port");
            port = Integer.parseInt(str);
        }
        if (props.contains("HdfsBroker.Port")) {
            str = props.getProperty("HdfsBroker.Port");
            port = Integer.parseInt(str);
        }
        short reactorCount = (str = props.getProperty("HdfsBroker.Reactors")) == null ? (short)org.hypertable.Common.System.processorCount : Short.parseShort(str);
        str = props.getProperty("HdfsBroker.Workers");
        int n = workerCount = str == null ? 20 : Integer.parseInt(str);
        if (verbose) {
            System.out.println("Num CPUs=" + org.hypertable.Common.System.processorCount);
            System.out.println("HdfsBroker.Port=" + port);
            System.out.println("HdfsBroker.Reactors=" + reactorCount);
            System.out.println("HdfsBroker.Workers=" + workerCount);
        }
        ReactorFactory.Initialize(reactorCount);
        Comm comm = new Comm(0);
        ms_app_queue = new ApplicationQueue(workerCount);
        ms_broker = new HdfsBroker(comm, props);
        HandlerFactory handlerFactory = new HandlerFactory(comm, ms_app_queue, ms_broker);
        comm.Listen(port, handlerFactory, null);
        ms_app_queue.Join();
    }

    private static class HandlerFactory
    implements ConnectionHandlerFactory {
        private Comm mComm;
        private ApplicationQueue mAppQueue;
        private HdfsBroker mBroker;

        public HandlerFactory(Comm comm, ApplicationQueue appQueue, HdfsBroker broker) {
            this.mComm = comm;
            this.mAppQueue = appQueue;
            this.mBroker = broker;
        }

        @Override
        public DispatchHandler newInstance() {
            return new ConnectionHandler(this.mComm, this.mAppQueue, this.mBroker);
        }
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            System.out.println("ShutdownHook called");
            ms_broker.mOpenFileMap.RemoveAll();
            ms_app_queue.Shutdown();
            try {
                FileSystem.closeAll();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

