/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.hive;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.hypertable.hadoop.hive.HTSerDe;
import org.hypertable.hadoop.hive.HiveHTInputFormat;
import org.hypertable.hadoop.hive.HiveHTOutputFormat;
import org.hypertable.thrift.ThriftClient;
import org.hypertable.thriftgen.Schema;

public class HTStorageHandler
implements HiveStorageHandler,
HiveMetaHook {
    private long mNamespaceId = 0L;
    private ThriftClient mClient = null;
    private Configuration mConf = null;

    private String getHTNamespace(Table tbl) {
        String namespace = (String)tbl.getParameters().get("hypertable.table.namespace");
        if (namespace == null) {
            namespace = (String)tbl.getSd().getSerdeInfo().getParameters().get("hypertable.table.namespace");
        }
        return namespace;
    }

    private String getHTTableName(Table tbl) {
        String tableName = (String)tbl.getParameters().get("hypertable.table.name");
        if (tableName == null) {
            tableName = (String)tbl.getSd().getSerdeInfo().getParameters().get("hypertable.table.name");
        }
        if (tableName == null) {
            tableName = tbl.getTableName();
        }
        return tableName;
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table tbl, boolean deleteData) throws MetaException {
        try {
            String tableName = this.getHTTableName(tbl);
            boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
            if (deleteData && !isExternal) {
                throw new MetaException("Drop table not yet supported via HTStorageHandler. Drop directly from Hypertable for now.");
            }
        }
        catch (Exception ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    public void preCreateTable(Table tbl) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
        if (tbl.getSd().getLocation() != null) {
            throw new MetaException("LOCATION may not be specified for Hypertable.");
        }
        try {
            String namespace = this.getHTNamespace(tbl);
            String tblName = this.getHTTableName(tbl);
            Map serdeParam = tbl.getSd().getSerdeInfo().getParameters();
            String htColumnsMapping = (String)serdeParam.get("hypertable.columns.mapping");
            if (htColumnsMapping == null) {
                throw new MetaException("No hypertable.columns.mapping defined in Serde.");
            }
            ArrayList<String> htColumnFamilies = new ArrayList<String>();
            ArrayList<String> htColumnQualifiers = new ArrayList<String>();
            ArrayList<byte[]> htColumnFamiliesBytes = new ArrayList<byte[]>();
            ArrayList<byte[]> htColumnQualifiersBytes = new ArrayList<byte[]>();
            int iKey = HTSerDe.parseColumnMapping(htColumnsMapping, htColumnFamilies, htColumnFamiliesBytes, htColumnQualifiers, htColumnQualifiersBytes);
            HashSet<String> uniqueColumnFamilies = new HashSet<String>(htColumnFamilies);
            uniqueColumnFamilies.remove(htColumnFamilies.get(iKey));
            if (this.mClient == null) {
                this.mClient = ThriftClient.create("localhost", 38080);
                this.mNamespaceId = this.mClient.open_namespace(namespace);
            }
            if (!isExternal) {
                throw new MetaException("Hypertable Storage handler only supports external tables currently.");
            }
            if (!this.mClient.exists_table(this.mNamespaceId, tblName)) {
                throw new MetaException("Hypertable table " + tblName + " doesn't exist while the table is declared as an external table.");
            }
            Schema schema = this.mClient.get_schema(this.mNamespaceId, tblName);
            for (int ii = 0; ii < htColumnFamilies.size(); ++ii) {
                if (ii == iKey || schema.getColumn_families().get(htColumnFamilies.get(ii)) != null) continue;
                throw new MetaException("Column Family " + (String)htColumnFamilies.get(ii) + " is not defined in Hypertable table " + tblName);
            }
        }
        catch (Exception ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
        finally {
            if (this.mNamespaceId != 0L && this.mClient != null) {
                try {
                    this.mClient.close_namespace(this.mNamespaceId);
                }
                catch (Exception ie) {
                    throw new MetaException(StringUtils.stringifyException((Throwable)ie));
                }
            }
        }
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
        String tableName = this.getHTTableName(table);
        try {
            if (!isExternal) {
                throw new MetaException("Hypertable Storage handler only supports external tables currently.");
            }
        }
        catch (Exception ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveHTInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveHTOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return HTSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public Configuration getConf() {
        return this.mConf;
    }

    public void setConf(Configuration conf) {
        this.mConf = conf;
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        jobProperties.put("hypertable.columns.mapping", tableProperties.getProperty("hypertable.columns.mapping"));
        String namespace = tableProperties.getProperty("hypertable.table.namespace");
        if (namespace == null) {
            namespace = tableProperties.getProperty("db");
        }
        jobProperties.put("hypertable.table.namespace", namespace);
        jobProperties.put("hypertable.mapred.output.namespace", namespace);
        String tableName = tableProperties.getProperty("hypertable.table.name");
        if (tableName == null) {
            tableName = tableProperties.getProperty("name");
        }
        jobProperties.put("hypertable.table.name", tableName);
        jobProperties.put("hypertable.mapred.output.table", tableName);
    }
}

