/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.hypertable.hadoop.hive.HTSerDe;
import org.hypertable.hadoop.hive.HiveHTSplit;
import org.hypertable.hadoop.mapred.RowInputFormat;
import org.hypertable.hadoop.mapred.TableSplit;
import org.hypertable.hadoop.mapreduce.ScanSpec;
import org.hypertable.hadoop.util.Row;

public class HiveHTInputFormat<K extends BytesWritable, V extends Row>
implements InputFormat<K, V>,
JobConfigurable {
    static final Log LOG = LogFactory.getLog(HiveHTInputFormat.class);
    private RowInputFormat htRowInputFormat = new RowInputFormat();
    private String tablename;
    private String namespace;
    private ScanSpec scanspec = new ScanSpec();

    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        int iKey;
        HiveHTSplit htSplit = (HiveHTSplit)split;
        if (this.namespace == null) {
            this.namespace = job.get("hypertable.table.namespace");
        }
        if (this.tablename == null) {
            this.tablename = job.get("hypertable.table.name");
        }
        String htColumnsMapping = job.get("hypertable.columns.mapping");
        ArrayList<String> htColumnFamilies = new ArrayList<String>();
        ArrayList<String> htColumnQualifiers = new ArrayList<String>();
        ArrayList<byte[]> htColumnFamiliesBytes = new ArrayList<byte[]>();
        ArrayList<byte[]> htColumnQualifiersBytes = new ArrayList<byte[]>();
        try {
            iKey = HTSerDe.parseColumnMapping(htColumnsMapping, htColumnFamilies, htColumnFamiliesBytes, htColumnQualifiers, htColumnQualifiersBytes);
        }
        catch (SerDeException se) {
            throw new IOException(se);
        }
        ArrayList readColIDs = ColumnProjectionUtils.getReadColumnIDs((Configuration)job);
        if (htColumnFamilies.size() < readColIDs.size()) {
            throw new IOException("Cannot read more columns than the given table contains.");
        }
        boolean addAll = readColIDs.size() == 0;
        boolean keys_only = true;
        this.scanspec.unsetColumns();
        if (!addAll) {
            Iterator i$ = readColIDs.iterator();
            while (i$.hasNext()) {
                int ii = (Integer)i$.next();
                if (ii == iKey) continue;
                if (htColumnQualifiers.get(ii) == null) {
                    this.scanspec.addToColumns((String)htColumnFamilies.get(ii));
                } else {
                    String column = (String)htColumnFamilies.get(ii) + ":" + (String)htColumnQualifiers.get(ii);
                    this.scanspec.addToColumns(column);
                }
                keys_only = false;
            }
        } else {
            for (int ii = 0; ii < htColumnFamilies.size(); ++ii) {
                if (ii == iKey) continue;
                if (htColumnQualifiers.get(ii) == null) {
                    this.scanspec.addToColumns((String)htColumnFamilies.get(ii));
                    continue;
                }
                String column = (String)htColumnFamilies.get(ii) + ":" + (String)htColumnQualifiers.get(ii);
                this.scanspec.addToColumns(column);
            }
            keys_only = false;
        }
        if (keys_only) {
            this.scanspec.setKeys_only(true);
        }
        this.scanspec.setVersions(1);
        ScanSpec spec = htSplit.getSplit().createScanSpec(this.scanspec);
        this.htRowInputFormat.set_scan_spec(spec);
        this.htRowInputFormat.set_namespace(this.namespace);
        this.htRowInputFormat.set_table_name(this.tablename);
        return this.htRowInputFormat.getRecordReader(htSplit.getSplit(), job, reporter);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        int iKey;
        Path[] tableNames = FileInputFormat.getInputPaths((JobConf)job);
        String htNamespace = job.get("hypertable.table.namespace");
        String htTableName = job.get("hypertable.table.name");
        this.htRowInputFormat.set_namespace(htNamespace);
        this.htRowInputFormat.set_table_name(htTableName);
        String htColumnsMapping = job.get("hypertable.columns.mapping");
        if (htColumnsMapping == null) {
            throw new IOException("hypertable.columns.mapping required for Hypertable Table.");
        }
        ArrayList<String> htColumnFamilies = new ArrayList<String>();
        ArrayList<String> htColumnQualifiers = new ArrayList<String>();
        ArrayList<byte[]> htColumnFamiliesBytes = new ArrayList<byte[]>();
        ArrayList<byte[]> htColumnQualifiersBytes = new ArrayList<byte[]>();
        try {
            iKey = HTSerDe.parseColumnMapping(htColumnsMapping, htColumnFamilies, htColumnFamiliesBytes, htColumnQualifiers, htColumnQualifiersBytes);
        }
        catch (SerDeException se) {
            throw new IOException(se);
        }
        ArrayList readColIDs = ColumnProjectionUtils.getReadColumnIDs((Configuration)job);
        if (htColumnFamilies.size() < readColIDs.size()) {
            throw new IOException("Cannot read more columns than the given table contains.");
        }
        boolean addAll = readColIDs.size() == 0;
        boolean keys_only = true;
        this.scanspec.unsetColumns();
        if (!addAll) {
            Iterator i$ = readColIDs.iterator();
            while (i$.hasNext()) {
                int ii = (Integer)i$.next();
                if (ii == iKey) continue;
                if (htColumnQualifiers.get(ii) == null) {
                    this.scanspec.addToColumns((String)htColumnFamilies.get(ii));
                } else {
                    String column = (String)htColumnFamilies.get(ii) + ":" + (String)htColumnQualifiers.get(ii);
                    this.scanspec.addToColumns(column);
                }
                keys_only = false;
            }
        } else {
            for (int ii = 0; ii < htColumnFamilies.size(); ++ii) {
                if (ii == iKey) continue;
                if (htColumnQualifiers.get(ii) == null) {
                    this.scanspec.addToColumns((String)htColumnFamilies.get(ii));
                    continue;
                }
                String column = (String)htColumnFamilies.get(ii) + ":" + (String)htColumnQualifiers.get(ii);
                this.scanspec.addToColumns(column);
            }
            keys_only = false;
        }
        if (keys_only) {
            this.scanspec.setKeys_only(true);
        }
        this.scanspec.setVersions(1);
        this.htRowInputFormat.set_scan_spec(this.scanspec);
        int num_splits = 0;
        InputSplit[] splits = this.htRowInputFormat.getSplits(job, num_splits);
        InputSplit[] results = new InputSplit[splits.length];
        for (int ii = 0; ii < splits.length; ++ii) {
            results[ii] = new HiveHTSplit((TableSplit)splits[ii], htColumnsMapping, tableNames[0]);
        }
        return results;
    }

    public void configure(JobConf job) {
        this.htRowInputFormat.configure(job);
    }
}

