/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.hypertable.hadoop.mapred.TableSplit;

public class HiveHTSplit
extends FileSplit
implements InputSplit {
    private String htColumnMapping;
    private TableSplit split;

    public HiveHTSplit() {
        super((Path)null, 0L, 0L, (String[])null);
        this.htColumnMapping = "";
        this.split = new TableSplit();
    }

    public HiveHTSplit(TableSplit split, String columnsMapping, Path dummyPath) {
        super(dummyPath, 0L, 0L, (String[])null);
        this.split = split;
        this.htColumnMapping = columnsMapping;
    }

    public TableSplit getSplit() {
        return this.split;
    }

    public String getColumnsMapping() {
        return this.htColumnMapping;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.htColumnMapping = in.readUTF();
        this.split.readFields(in);
    }

    public String toString() {
        return "TableSplit: split=" + this.split + ", columnMapping=" + this.htColumnMapping + ", FileSplit=" + super.toString();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.htColumnMapping);
        this.split.write(out);
    }

    public long getLength() {
        return this.split.getLength();
    }

    public String[] getLocations() throws IOException {
        return this.split.getLocations();
    }
}

