/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.hypertable.hadoop.hive.HTSerDe;
import org.hypertable.hadoop.hive.LazyHTCellMap;
import org.hypertable.hadoop.util.Row;

public class LazyHTRow
extends LazyStruct {
    private List<String> htColumnFamilies;
    private List<String> htColumnQualifiers;
    private List<byte[]> htColumnFamiliesBytes;
    private List<byte[]> htColumnQualifiersBytes;
    private Row htRow;
    private ArrayList<Object> cachedList;

    public LazyHTRow(LazySimpleStructObjectInspector oi) {
        super(oi);
    }

    public void init(Row row, List<String> htColumnFamilies, List<byte[]> htColumnFamiliesBytes, List<String> htColumnQualifiers, List<byte[]> htColumnQualifiersBytes) {
        this.htRow = row;
        this.htColumnFamilies = htColumnFamilies;
        this.htColumnFamiliesBytes = htColumnFamiliesBytes;
        this.htColumnQualifiers = htColumnQualifiers;
        this.htColumnQualifiersBytes = htColumnQualifiersBytes;
        this.setParsed(false);
    }

    private void parse() {
        if (this.getFields() == null) {
            List fieldRefs = ((StructObjectInspector)this.getInspector()).getAllStructFieldRefs();
            this.setFields(new LazyObject[fieldRefs.size()]);
            for (int i = 0; i < this.getFields().length; ++i) {
                String htColumnFamily = this.htColumnFamilies.get(i);
                String htColumnQualifier = this.htColumnQualifiers.get(i);
                this.getFields()[i] = htColumnQualifier == null && !HTSerDe.isSpecialColumn(htColumnFamily) ? new LazyHTCellMap((LazyMapObjectInspector)((StructField)fieldRefs.get(i)).getFieldObjectInspector()) : LazyFactory.createLazyObject((ObjectInspector)((StructField)fieldRefs.get(i)).getFieldObjectInspector());
            }
            this.setFieldInited(new boolean[this.getFields().length]);
        }
        Arrays.fill(this.getFieldInited(), false);
        this.setParsed(true);
    }

    public Object getField(int fieldID) {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.uncheckedGetField(fieldID);
    }

    private Object uncheckedGetField(int fieldID) {
        if (!this.getFieldInited()[fieldID]) {
            this.getFieldInited()[fieldID] = true;
            ByteArrayRef ref = null;
            String columnFamily = this.htColumnFamilies.get(fieldID);
            String columnQualifier = this.htColumnQualifiers.get(fieldID);
            byte[] columnFamilyBytes = this.htColumnFamiliesBytes.get(fieldID);
            byte[] columnQualifierBytes = this.htColumnQualifiersBytes.get(fieldID);
            if (HTSerDe.isSpecialColumn(columnFamily)) {
                assert (columnQualifier == null);
                ref = new ByteArrayRef();
                ref.setData(this.htRow.getRowKey());
            } else if (columnQualifier == null) {
                ((LazyHTCellMap)this.getFields()[fieldID]).init(this.htRow, columnFamily);
            } else if (this.htRow.containsCol(columnFamilyBytes, columnQualifierBytes)) {
                ref = new ByteArrayRef();
                ref.setData(this.htRow.getValue(columnFamilyBytes, columnQualifierBytes));
            } else {
                return null;
            }
            if (ref != null) {
                this.getFields()[fieldID].init(ref, 0, ref.getData().length);
            }
        }
        return this.getFields()[fieldID].getObject();
    }

    public ArrayList<Object> getFieldsAsList() {
        if (!this.getParsed()) {
            this.parse();
        }
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.getFields().length; ++i) {
            this.cachedList.add(this.uncheckedGetField(i));
        }
        return this.cachedList;
    }

    public Object getObject() {
        return this;
    }
}

