/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.mapred;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.hypertable.hadoop.mapred.TableSplit;
import org.hypertable.hadoop.mapreduce.ScanSpec;
import org.hypertable.hadoop.util.Row;
import org.hypertable.thrift.SerializedCellsReader;
import org.hypertable.thrift.ThriftClient;
import org.hypertable.thriftgen.ClientException;

public class RowInputFormat
implements InputFormat<BytesWritable, Row>,
JobConfigurable {
    final Log LOG = LogFactory.getLog(InputFormat.class);
    public static final String NAMESPACE = "hypertable.mapreduce.input.namespace";
    public static final String TABLE = "hypertable.mapreduce.input.table";
    public static final String SCAN_SPEC = "hypertable.mapreduce.input.scan-spec";
    public static final String START_ROW = "hypertable.mapreduce.input.startrow";
    public static final String END_ROW = "hypertable.mapreduce.input.endrow";
    private ThriftClient m_client = null;
    private ScanSpec m_base_spec = null;
    private String m_tablename = null;
    private String m_namespace = null;

    public void configure(JobConf job) {
        try {
            if (this.m_base_spec == null) {
                if (job.get(SCAN_SPEC) == null) {
                    job.set(SCAN_SPEC, new ScanSpec().toSerializedText());
                }
                this.m_base_spec = ScanSpec.serializedTextToScanSpec(job.get(SCAN_SPEC));
                this.m_base_spec.setVersions(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void set_scan_spec(ScanSpec spec) {
        this.m_base_spec = spec;
        this.m_base_spec.setVersions(1);
    }

    public void set_namespace(String namespace) {
        this.m_namespace = namespace;
    }

    public void set_table_name(String tablename) {
        this.m_tablename = tablename;
    }

    public RecordReader<BytesWritable, Row> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        try {
            TableSplit ts = (TableSplit)split;
            if (this.m_namespace == null) {
                this.m_namespace = job.get(NAMESPACE);
            }
            if (this.m_tablename == null) {
                this.m_tablename = job.get(TABLE);
            }
            ScanSpec scan_spec = ts.createScanSpec(this.m_base_spec);
            if (this.m_client == null) {
                this.m_client = ThriftClient.create("localhost", 38080);
            }
            return new HypertableRecordReader(this.m_client, this.m_namespace, this.m_tablename, scan_spec);
        }
        catch (TTransportException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (TException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        long ns = 0L;
        try {
            if (this.m_client == null) {
                this.m_client = ThriftClient.create("localhost", 38080);
            }
            String namespace = this.m_namespace == null ? job.get(NAMESPACE) : this.m_namespace;
            String tablename = this.m_tablename == null ? job.get(TABLE) : this.m_tablename;
            ns = this.m_client.open_namespace(namespace);
            List<org.hypertable.thriftgen.TableSplit> tsplits = this.m_client.get_table_splits(ns, tablename);
            InputSplit[] splits = new InputSplit[tsplits.size()];
            try {
                int pos = 0;
                for (org.hypertable.thriftgen.TableSplit ts : tsplits) {
                    byte[] start_row = ts.start_row == null ? null : ts.start_row.getBytes("UTF-8");
                    byte[] end_row = ts.end_row == null ? null : ts.end_row.getBytes("UTF-8");
                    TableSplit split = new TableSplit(tablename.getBytes("UTF-8"), start_row, end_row, ts.ip_address);
                    splits[pos++] = split;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            InputSplit[] inputSplitArray = splits;
            return inputSplitArray;
        }
        catch (TTransportException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (TException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (ClientException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        finally {
            if (ns != 0L) {
                try {
                    this.m_client.close_namespace(ns);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
        }
    }

    protected class HypertableRecordReader
    implements RecordReader<BytesWritable, Row> {
        private ThriftClient m_client = null;
        private long m_scanner = 0L;
        private long m_ns = 0L;
        private String m_namespace = null;
        private String m_tablename = null;
        private ScanSpec m_scan_spec = null;
        private long m_bytes_read = 0L;
        private byte[] m_serialized_cells = null;
        private Row m_value;
        private ByteBuffer m_row = null;
        private BytesWritable m_key = null;
        private SerializedCellsReader m_reader = new SerializedCellsReader(null);
        private boolean m_eos = false;

        public HypertableRecordReader(ThriftClient client, String namespace, String tablename, ScanSpec scan_spec) throws IOException {
            this.m_client = client;
            this.m_namespace = namespace;
            this.m_tablename = tablename;
            this.m_scan_spec = scan_spec;
            try {
                this.m_ns = this.m_client.open_namespace(this.m_namespace);
                this.m_scanner = this.m_client.open_scanner(this.m_ns, this.m_tablename, this.m_scan_spec);
            }
            catch (TTransportException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (TException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (ClientException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }

        public BytesWritable createKey() {
            return new BytesWritable();
        }

        public Row createValue() {
            return new Row();
        }

        public void close() {
            try {
                this.m_client.close_scanner(this.m_scanner);
                this.m_client.close_namespace(this.m_ns);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public long getPos() throws IOException {
            return this.m_bytes_read;
        }

        public float getProgress() {
            if (this.m_bytes_read >= 200000000L) {
                return 1.0f;
            }
            return (float)this.m_bytes_read / 2.0E8f;
        }

        public boolean next(BytesWritable key, Row value) throws IOException {
            try {
                if (this.m_eos) {
                    return false;
                }
                this.m_row = this.m_client.next_row_serialized(this.m_scanner);
                this.m_row.mark();
                this.m_reader.reset(this.m_row);
                if (this.m_reader.next()) {
                    this.m_key = new BytesWritable(this.m_reader.get_row());
                    this.m_value = new Row(this.m_row);
                } else if (this.m_reader.eos()) {
                    this.m_eos = true;
                    return false;
                }
                key.set(this.m_key);
                value.set(this.m_value);
                this.m_bytes_read += (long)value.getSerializedRow().length;
            }
            catch (TTransportException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (TException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (ClientException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            return true;
        }
    }
}

