/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.mapreduce;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.hypertable.hadoop.mapreduce.KeyWritable;
import org.hypertable.hadoop.mapreduce.ScanSpec;
import org.hypertable.hadoop.mapreduce.TableSplit;
import org.hypertable.thrift.ThriftClient;
import org.hypertable.thriftgen.Cell;
import org.hypertable.thriftgen.ClientException;
import org.hypertable.thriftgen.RowInterval;

public class InputFormat
extends org.apache.hadoop.mapreduce.InputFormat<KeyWritable, BytesWritable> {
    final Log LOG = LogFactory.getLog(InputFormat.class);
    public static final String NAMESPACE = "hypertable.mapreduce.input.namespace";
    public static final String TABLE = "hypertable.mapreduce.input.table";
    public static final String SCAN_SPEC = "hypertable.mapreduce.input.scan-spec";
    private ThriftClient m_client = null;
    private ScanSpec m_base_spec = null;
    private String m_tablename = null;
    private String m_namespace = null;

    public org.apache.hadoop.mapreduce.RecordReader<KeyWritable, BytesWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        try {
            TableSplit ts = (TableSplit)split;
            if (this.m_namespace == null) {
                this.m_namespace = context.getConfiguration().get(NAMESPACE);
            }
            if (this.m_tablename == null) {
                this.m_tablename = context.getConfiguration().get(TABLE);
                this.m_base_spec = ScanSpec.serializedTextToScanSpec(context.getConfiguration().get(SCAN_SPEC));
                System.out.println(this.m_base_spec);
            }
            ScanSpec scan_spec = ts.createScanSpec(this.m_base_spec);
            System.out.println(scan_spec);
            if (this.m_client == null) {
                this.m_client = ThriftClient.create("localhost", 38080);
            }
            return new RecordReader(this.m_client, this.m_namespace, this.m_tablename, scan_spec);
        }
        catch (TTransportException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (TException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        long ns = 0L;
        try {
            Iterator<RowInterval> iter;
            RowInterval ri = null;
            if (this.m_client == null) {
                this.m_client = ThriftClient.create("localhost", 38080);
            }
            if (this.m_base_spec == null) {
                this.m_base_spec = ScanSpec.serializedTextToScanSpec(context.getConfiguration().get(SCAN_SPEC));
            }
            if ((iter = this.m_base_spec.getRow_intervalsIterator()) != null && iter.hasNext()) {
                ri = iter.next();
                if (iter.hasNext()) {
                    System.out.println("InputFormat only allows a single ROW interval");
                    System.exit(-1);
                }
            }
            String namespace = context.getConfiguration().get(NAMESPACE);
            String tablename = context.getConfiguration().get(TABLE);
            ns = this.m_client.namespace_open(namespace);
            List<org.hypertable.thriftgen.TableSplit> tsplits = this.m_client.table_get_splits(ns, tablename);
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(tsplits.size());
            for (org.hypertable.thriftgen.TableSplit ts : tsplits) {
                if (ri != null && (ri.isSetStart_row() && ts.end_row != null && ts.end_row.compareTo(ri.getStart_row()) <= 0 && (ts.end_row.compareTo(ri.getStart_row()) != 0 || !ri.isStart_inclusive()) || ri.isSetEnd_row() && ts.start_row != null && ts.start_row.compareTo(ri.getEnd_row()) >= 0)) continue;
                byte[] start_row = ts.start_row == null ? null : ts.start_row.getBytes("UTF-8");
                byte[] end_row = ts.end_row == null ? null : ts.end_row.getBytes("UTF-8");
                TableSplit split = new TableSplit(tablename.getBytes("UTF-8"), start_row, end_row, ts.hostname);
                splits.add(split);
            }
            ArrayList<InputSplit> arrayList = splits;
            return arrayList;
        }
        catch (TTransportException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (TException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (ClientException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        finally {
            if (ns != 0L) {
                try {
                    this.m_client.namespace_close(ns);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
        }
    }

    protected class RecordReader
    extends org.apache.hadoop.mapreduce.RecordReader<KeyWritable, BytesWritable> {
        private ThriftClient m_client = null;
        private long m_ns = 0L;
        private long m_scanner = 0L;
        private ScanSpec m_scan_spec = null;
        private String m_namespace = null;
        private String m_tablename = null;
        private long m_bytes_read = 0L;
        private List<Cell> m_cells = null;
        private Iterator<Cell> m_iter = null;
        private boolean m_eos = false;
        private KeyWritable m_key = new KeyWritable();
        private BytesWritable m_value = null;

        public RecordReader(ThriftClient client, String namespace, String tablename, ScanSpec scan_spec) {
            this.m_client = client;
            this.m_namespace = namespace;
            this.m_tablename = tablename;
            this.m_scan_spec = scan_spec;
        }

        public void initialize(InputSplit inputsplit, TaskAttemptContext context) throws IOException, InterruptedException {
            try {
                this.m_ns = this.m_client.namespace_open(this.m_namespace);
                this.m_scanner = this.m_client.scanner_open(this.m_ns, this.m_tablename, this.m_scan_spec);
            }
            catch (TTransportException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (TException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (ClientException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }

        public void close() {
            try {
                this.m_client.scanner_close(this.m_scanner);
                this.m_client.namespace_close(this.m_ns);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public float getProgress() {
            if (this.m_bytes_read >= 200000000L) {
                return 1.0f;
            }
            return (float)this.m_bytes_read / 2.0E8f;
        }

        public KeyWritable getCurrentKey() throws IOException, InterruptedException {
            return this.m_key;
        }

        public BytesWritable getCurrentValue() throws IOException, InterruptedException {
            return this.m_value;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            try {
                if (this.m_eos) {
                    return false;
                }
                if (this.m_cells == null || !this.m_iter.hasNext()) {
                    this.m_cells = this.m_client.scanner_get_cells(this.m_scanner);
                    if (this.m_cells.isEmpty()) {
                        this.m_eos = true;
                        return false;
                    }
                    this.m_iter = this.m_cells.iterator();
                }
                Cell cell = this.m_iter.next();
                this.m_key.load(cell.key);
                byte[] value = new byte[]{};
                this.m_bytes_read += (long)(24 + cell.key.row.length());
                if (cell.value != null && cell.value.hasRemaining()) {
                    value = new byte[cell.value.remaining()];
                    this.m_bytes_read += (long)cell.value.limit();
                    System.arraycopy(cell.value.array(), cell.value.arrayOffset() + cell.value.position(), value, 0, value.length);
                }
                this.m_value = new BytesWritable(value);
                this.m_bytes_read += (long)(24 + cell.key.row.length() + cell.value.limit());
                if (cell.key.column_qualifier != null) {
                    this.m_bytes_read += (long)cell.key.column_qualifier.length();
                }
            }
            catch (TTransportException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (TException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (ClientException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            return true;
        }
    }
}

