/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.hypertable.hadoop.mapreduce.ScanSpec;
import org.hypertable.hadoop.util.Serialization;
import org.hypertable.thriftgen.RowInterval;

public class TableSplit
extends InputSplit
implements Writable,
Comparable<TableSplit> {
    private byte[] m_tablename;
    private byte[] m_startrow;
    private byte[] m_endrow;
    private String m_hostname;

    public TableSplit() {
        this(new byte[0], new byte[0], new byte[0], "");
    }

    public TableSplit(byte[] tableName, byte[] startRow, byte[] endRow, String hostname) {
        this.m_tablename = tableName;
        this.m_startrow = startRow;
        this.m_endrow = endRow;
        this.m_hostname = hostname;
        if (endRow != null && endRow.length == 2 && endRow[0] == -1 && endRow[1] == -1) {
            this.m_endrow = null;
        }
    }

    public byte[] getTableName() {
        return this.m_tablename;
    }

    public byte[] getStartRow() {
        return this.m_startrow;
    }

    public byte[] getEndRow() {
        return this.m_endrow;
    }

    public String getRangeLocation() {
        return this.m_hostname;
    }

    public String[] getLocations() {
        int period_offset = this.m_hostname.indexOf(46);
        if (period_offset == -1) {
            return new String[]{this.m_hostname};
        }
        return new String[]{this.m_hostname, this.m_hostname.substring(0, period_offset)};
    }

    public long getLength() {
        return 0L;
    }

    public ScanSpec createScanSpec(ScanSpec base_spec) {
        ScanSpec scan_spec = new ScanSpec(base_spec);
        RowInterval interval = new RowInterval();
        scan_spec.unsetRow_intervals();
        try {
            Iterator<RowInterval> i$;
            if (this.m_startrow != null && this.m_startrow.length > 0) {
                interval.setStart_row(new String(this.m_startrow, "UTF-8"));
                interval.setStart_rowIsSet(true);
                interval.setStart_inclusive(false);
                interval.setStart_inclusiveIsSet(true);
            }
            if (this.m_endrow != null && this.m_endrow.length > 0) {
                interval.setEnd_row(new String(this.m_endrow, "UTF-8"));
                interval.setEnd_rowIsSet(true);
                interval.setEnd_inclusive(true);
                interval.setEnd_inclusiveIsSet(true);
            }
            if (base_spec.isSetRow_intervals() && (i$ = base_spec.getRow_intervals().iterator()).hasNext()) {
                RowInterval ri = i$.next();
                if (ri.isSetStart_row() && (this.m_startrow == null || ri.getStart_row().compareTo(new String(this.m_startrow, "UTF-8")) > 0)) {
                    interval.setStart_row(ri.getStart_row());
                    interval.setStart_rowIsSet(true);
                    interval.setStart_inclusive(ri.isStart_inclusive());
                    interval.setStart_inclusiveIsSet(true);
                }
                if (ri.isSetEnd_row() && (this.m_endrow == null || ri.getEnd_row().compareTo(new String(this.m_endrow, "UTF-8")) < 0)) {
                    interval.setEnd_row(ri.getEnd_row());
                    interval.setEnd_rowIsSet(true);
                    interval.setEnd_inclusive(ri.isEnd_inclusive());
                    interval.setEnd_inclusiveIsSet(true);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        if (interval.isSetStart_row() || interval.isSetEnd_row()) {
            scan_spec.addToRow_intervals(interval);
            scan_spec.setRow_intervalsIsSet(true);
        }
        return scan_spec;
    }

    public void readFields(DataInput in) throws IOException {
        this.m_tablename = Serialization.readByteArray(in);
        this.m_startrow = Serialization.readByteArray(in);
        this.m_endrow = Serialization.readByteArray(in);
        this.m_hostname = Serialization.toString(Serialization.readByteArray(in));
    }

    public void write(DataOutput out) throws IOException {
        Serialization.writeByteArray(out, this.m_tablename);
        Serialization.writeByteArray(out, this.m_startrow);
        Serialization.writeByteArray(out, this.m_endrow);
        Serialization.writeByteArray(out, Serialization.toBytes(this.m_hostname));
    }

    public String toString() {
        String start_str = new String();
        String end_str = new String();
        if (this.m_startrow != null) {
            start_str = Serialization.toStringBinary(this.m_startrow);
        }
        if (this.m_endrow != null) {
            end_str = Serialization.toStringBinary(this.m_endrow);
        }
        return this.m_hostname + ":" + start_str + "," + end_str;
    }

    @Override
    public int compareTo(TableSplit split) {
        return Serialization.compareTo(this.getStartRow(), split.getStartRow());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TableSplit)) {
            return false;
        }
        return Serialization.equals(this.m_tablename, ((TableSplit)o).m_tablename) && Serialization.equals(this.m_startrow, ((TableSplit)o).m_startrow) && Serialization.equals(this.m_endrow, ((TableSplit)o).m_endrow) && this.m_hostname.equals(((TableSplit)o).m_hostname);
    }
}

