/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class Serialization {
    public static byte[] readByteArray(DataInput in) throws IOException {
        int len = WritableUtils.readVInt((DataInput)in);
        if (len < 0) {
            throw new NegativeArraySizeException(Integer.toString(len));
        }
        byte[] result = new byte[len];
        in.readFully(result, 0, len);
        return result;
    }

    public static byte[] readByteArrayThrowsRuntime(DataInput in) {
        try {
            return Serialization.readByteArray(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeByteArray(DataOutput out, byte[] b) throws IOException {
        if (b == null) {
            WritableUtils.writeVInt((DataOutput)out, (int)0);
        } else {
            Serialization.writeByteArray(out, b, 0, b.length);
        }
    }

    public static void writeByteArray(DataOutput out, byte[] b, int offset, int length) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)length);
        out.write(b, offset, length);
    }

    public static int writeByteArray(byte[] tgt, int tgtOffset, byte[] src, int srcOffset, int srcLength) {
        byte[] vint = Serialization.vintToBytes(srcLength);
        System.arraycopy(vint, 0, tgt, tgtOffset, vint.length);
        int offset = tgtOffset + vint.length;
        System.arraycopy(src, srcOffset, tgt, offset, srcLength);
        return offset + srcLength;
    }

    public static byte[] toBytes(String s) {
        if (s == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        byte[] result = null;
        try {
            result = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return null;
        }
        return Serialization.toString(b, 0, b.length);
    }

    public static String toString(byte[] b1, String sep, byte[] b2) {
        return Serialization.toString(b1, 0, b1.length) + sep + Serialization.toString(b2, 0, b2.length);
    }

    public static String toString(byte[] b, int off, int len) {
        if (b == null) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        String result = null;
        try {
            result = new String(b, off, len, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String toStringBinary(byte[] b) {
        return Serialization.toStringBinary(b, 0, b.length);
    }

    public static String toStringBinary(byte[] b, int off, int len) {
        StringBuilder result = new StringBuilder();
        try {
            String first = new String(b, off, len, "ISO-8859-1");
            for (int i = 0; i < first.length(); ++i) {
                int ch = first.charAt(i) & 0xFF;
                if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch == 44 || ch == 95 || ch == 45 || ch == 58 || ch == 32 || ch == 60 || ch == 62 || ch == 61 || ch == 47 || ch == 46) {
                    result.append(first.charAt(i));
                    continue;
                }
                result.append(String.format("\\x%02X", ch));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static byte[] vintToBytes(long vint) {
        long i = vint;
        int size = WritableUtils.getVIntSize((long)i);
        byte[] result = new byte[size];
        int offset = 0;
        if (i >= -112L && i <= 127L) {
            result[offset] = (byte)i;
            return result;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        result[offset++] = (byte)len;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            result[offset++] = (byte)((i & mask) >> shiftbits);
        }
        return result;
    }

    public static int compareTo(byte[] left, byte[] right) {
        return Serialization.compareTo(left, 0, left.length, right, 0, right.length);
    }

    public static int compareTo(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int end1 = s1 + l1;
        int end2 = s2 + l2;
        int i = s1;
        for (int j = s2; i < end1 && j < end2; ++i, ++j) {
            int a = b1[i] & 0xFF;
            int b = b2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return l1 - l2;
    }

    public static boolean equals(byte[] left, byte[] right) {
        return left == null && right == null ? true : (left == null || right == null || left.length != right.length ? false : Serialization.compareTo(left, right) == 0);
    }

    public static int hashCode(byte[] b) {
        return Serialization.hashCode(b, b.length);
    }

    public static int hashCode(byte[] b, int length) {
        return WritableComparator.hashBytes((byte[])b, (int)length);
    }

    public static class ByteArrayComparator
    implements RawComparator<byte[]> {
        public static Comparator<byte[]> GET = new ByteArrayComparator();

        public int compare(byte[] left, byte[] right) {
            return Serialization.compareTo(left, right);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return Serialization.compareTo(b1, s1, l1, b2, s2, l2);
        }
    }
}

