/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;

public class TableSplit
implements InputSplit {
    private Text m_tableName = new Text();
    private Text m_startRow = new Text();
    private Text m_endRow = new Text();
    private Text m_location = new Text();

    public TableSplit() {
    }

    public TableSplit(Text tableName, Text startRow, Text endRow, Text location) {
        this();
        this.m_location.set(location);
        this.m_tableName.set(tableName);
        this.m_startRow.set(startRow);
        this.m_endRow.set(endRow);
    }

    public Text getTableName() {
        return this.m_tableName;
    }

    public Text getStartRow() {
        return this.m_startRow;
    }

    public Text getEndRow() {
        return this.m_endRow;
    }

    public long getLength() {
        return 0L;
    }

    public Text getLocation() {
        return this.m_location;
    }

    public void readFields(DataInput in) throws IOException {
        this.m_tableName.readFields(in);
        this.m_startRow.readFields(in);
        this.m_endRow.readFields(in);
    }

    public String[] getLocations() {
        return new String[0];
    }

    public void write(DataOutput out) throws IOException {
        this.m_tableName.write(out);
        this.m_startRow.write(out);
        this.m_endRow.write(out);
    }

    public String toString() {
        return this.m_tableName + "," + this.m_startRow + "," + this.m_endRow;
    }
}

