/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZKProducerConsumer
implements Watcher {
    static ZooKeeper zk = null;
    static Integer mutex;
    String root;

    ZKProducerConsumer(String address) {
        if (zk == null) {
            try {
                System.out.println("Starting ZK:");
                zk = new ZooKeeper(address, 3000, (Watcher)this);
                mutex = new Integer(-1);
                System.out.println("Finished starting ZK: " + zk);
            }
            catch (IOException e) {
                System.out.println(e.toString());
                zk = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(WatchedEvent event) {
        Integer n = mutex;
        synchronized (n) {
            mutex.notify();
        }
    }

    public static class Queue
    extends ZKProducerConsumer {
        Queue(String address, String name) {
            super(address);
            this.root = name;
            if (zk != null) {
                try {
                    Stat s = zk.exists(this.root, false);
                    if (s == null) {
                        zk.create(this.root, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                }
                catch (KeeperException e) {
                    System.out.println("Keeper exception when instantiating queue: " + e.toString());
                }
                catch (InterruptedException e) {
                    System.out.println("Interrupted exception");
                }
            }
        }

        boolean produce(String key) throws KeeperException, InterruptedException {
            byte[] value = key.getBytes();
            zk.create(this.root + "/key", value, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String consume() throws KeeperException, InterruptedException {
            String retvalue = null;
            Stat stat = null;
            while (true) {
                Integer n = mutex;
                synchronized (n) {
                    List list = zk.getChildren(this.root, true);
                    if (list.size() != 0) {
                        String path = this.root + "/" + (String)list.get(0);
                        byte[] b = zk.getData(path, false, stat);
                        retvalue = new String(b);
                        zk.delete(path, -1);
                        return retvalue;
                    }
                    System.out.println("Going to wait");
                    mutex.wait();
                }
            }
        }
    }

    public static class QueueElement {
        public String key;
        public long writeTime;

        QueueElement(String key, long writeTime) {
            this.key = key;
            this.writeTime = writeTime;
        }
    }
}

