/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.elasticsearch.action.admin.indices.exists.IndicesExistsResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;

public class ElasticSearchClient
extends DB {
    public static final String DEFAULT_CLUSTER_NAME = "es.ycsb.cluster";
    public static final String DEFAULT_INDEX_KEY = "es.ycsb";
    public static final String DEFAULT_REMOTE_HOST = "localhost:9300";
    private Node node;
    private Client client;
    private String indexKey;
    private Boolean remoteMode;

    public void init() throws DBException {
        Properties props = this.getProperties();
        this.indexKey = props.getProperty("es.index.key", DEFAULT_INDEX_KEY);
        String clusterName = props.getProperty("cluster.name", DEFAULT_CLUSTER_NAME);
        this.remoteMode = Boolean.parseBoolean(props.getProperty("elasticsearch.remote", "false"));
        Boolean newdb = Boolean.parseBoolean(props.getProperty("elasticsearch.newdb", "false"));
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder().put("node.local", "true").put("path.data", System.getProperty("java.io.tmpdir") + "/esdata").put("discovery.zen.ping.multicast.enabled", "false").put("index.mapping._id.indexed", "true").put("index.gateway.type", "none").put("gateway.type", "none").put("index.number_of_shards", "1").put("index.number_of_replicas", "0");
        settings.put(props);
        System.out.println("ElasticSearch starting node = " + settings.get("cluster.name"));
        System.out.println("ElasticSearch node data path = " + settings.get("path.data"));
        System.out.println("ElasticSearch Remote Mode = " + this.remoteMode);
        if (this.remoteMode.booleanValue()) {
            settings.put("client.transport.sniff", true).put("client.transport.ignore_cluster_name", false).put("client.transport.ping_timeout", "30s").put("client.transport.nodes_sampler_interval", "30s");
            String[] nodeList = props.getProperty("elasticsearch.hosts.list", DEFAULT_REMOTE_HOST).split(",");
            System.out.println("ElasticSearch Remote Hosts = " + props.getProperty("elasticsearch.hosts.list", DEFAULT_REMOTE_HOST));
            TransportClient tClient = new TransportClient((Settings.Builder)settings);
            for (String h : nodeList) {
                String[] node = h.split(":");
                tClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(node[0], Integer.parseInt(node[1])));
            }
            this.client = tClient;
        } else {
            this.node = NodeBuilder.nodeBuilder().clusterName(clusterName).settings((Settings.Builder)settings).node();
            this.node.start();
            this.client = this.node.client();
        }
        if (newdb.booleanValue()) {
            this.client.admin().indices().prepareDelete(new String[]{this.indexKey}).execute().actionGet();
            this.client.admin().indices().prepareCreate(this.indexKey).execute().actionGet();
        } else {
            boolean exists = ((IndicesExistsResponse)this.client.admin().indices().exists(Requests.indicesExistsRequest((String[])new String[]{this.indexKey})).actionGet()).isExists();
            if (!exists) {
                this.client.admin().indices().prepareCreate(this.indexKey).execute().actionGet();
            }
        }
    }

    public void cleanup() throws DBException {
        if (!this.remoteMode.booleanValue()) {
            if (!this.node.isClosed()) {
                this.client.close();
                this.node.stop();
                this.node.close();
            }
        } else {
            this.client.close();
        }
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            XContentBuilder doc = XContentFactory.jsonBuilder().startObject();
            for (Map.Entry entry : StringByteIterator.getStringMap(values).entrySet()) {
                doc.field((String)entry.getKey(), (String)entry.getValue());
            }
            doc.endObject();
            this.client.prepareIndex(this.indexKey, table, key).setSource(doc).execute().actionGet();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public int delete(String table, String key) {
        try {
            this.client.prepareDelete(this.indexKey, table, key).execute().actionGet();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        block6: {
            try {
                GetResponse response = (GetResponse)this.client.prepareGet(this.indexKey, table, key).execute().actionGet();
                if (!response.isExists()) break block6;
                if (fields != null) {
                    for (String field : fields) {
                        result.put(field, (ByteIterator)new StringByteIterator((String)response.getSource().get(field)));
                    }
                } else {
                    for (String field : response.getSource().keySet()) {
                        result.put(field, (ByteIterator)new StringByteIterator((String)response.getSource().get(field)));
                    }
                }
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 1;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            GetResponse response = (GetResponse)this.client.prepareGet(this.indexKey, table, key).execute().actionGet();
            if (response.isExists()) {
                for (Map.Entry entry : StringByteIterator.getStringMap(values).entrySet()) {
                    response.getSource().put(entry.getKey(), entry.getValue());
                }
                this.client.prepareIndex(this.indexKey, table, key).setSource(response.getSource()).execute().actionGet();
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        try {
            RangeFilterBuilder filter = FilterBuilders.rangeFilter((String)"_id").gte((Object)startkey);
            SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.indexKey}).setTypes(new String[]{table}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setFilter((FilterBuilder)filter).setSize(recordcount).execute().actionGet();
            for (SearchHit hit : response.getHits()) {
                HashMap<String, StringByteIterator> entry = new HashMap<String, StringByteIterator>(fields.size());
                for (String field : fields) {
                    entry.put(field, new StringByteIterator((String)hit.getSource().get(field)));
                }
                result.add(entry);
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }
}

