/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TProtocolFactory;

public class IndexScanCommand {
    public static final IndexScanCommandSerializer serializer = new IndexScanCommandSerializer();
    public final String keyspace;
    public final String column_family;
    public final IndexClause index_clause;
    public final SlicePredicate predicate;
    public final AbstractBounds<RowPosition> range;

    public IndexScanCommand(String keyspace, String column_family, IndexClause index_clause, SlicePredicate predicate, AbstractBounds<RowPosition> range) {
        this.keyspace = keyspace;
        this.column_family = column_family;
        this.index_clause = index_clause;
        this.predicate = predicate;
        this.range = range;
    }

    public MessageOut<IndexScanCommand> createMessage() {
        return new MessageOut<IndexScanCommand>(MessagingService.Verb.INDEX_SCAN, this, serializer);
    }

    static class IndexScanCommandSerializer
    implements IVersionedSerializer<IndexScanCommand> {
        IndexScanCommandSerializer() {
        }

        @Override
        public void serialize(IndexScanCommand o, DataOutput out, int version) throws IOException {
            assert (version < 6);
            out.writeUTF(o.keyspace);
            out.writeUTF(o.column_family);
            TSerializer ser = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            FBUtilities.serialize(ser, (TBase)o.index_clause, out);
            FBUtilities.serialize(ser, (TBase)o.predicate, out);
            AbstractBounds.serializer.serialize(o.range, out, version);
        }

        @Override
        public IndexScanCommand deserialize(DataInput in, int version) throws IOException {
            assert (version < 6);
            String keyspace = in.readUTF();
            String columnFamily = in.readUTF();
            IndexClause indexClause = new IndexClause();
            SlicePredicate predicate = new SlicePredicate();
            TDeserializer dser = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            FBUtilities.deserialize(dser, (TBase)indexClause, in);
            FBUtilities.deserialize(dser, (TBase)predicate, in);
            AbstractBounds<RowPosition> range = ((AbstractBounds)AbstractBounds.serializer.deserialize(in, version)).toRowBounds();
            return new IndexScanCommand(keyspace, columnFamily, indexClause, predicate, range);
        }

        @Override
        public long serializedSize(IndexScanCommand object, int version) {
            throw new UnsupportedOperationException();
        }
    }
}

