/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

public class PublicTermsFilter
extends Filter {
    Set<Term> terms = new TreeSet<Term>();

    public void addTerm(Term term) {
        this.terms.add(term);
    }

    public Set<Term> getTerms() {
        return this.terms;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        PublicTermsFilter test = (PublicTermsFilter)((Object)obj);
        return this.terms == test.terms || this.terms != null && ((Object)this.terms).equals(test.terms);
    }

    public int hashCode() {
        int hash = 9;
        for (Term term : this.terms) {
            hash = 31 * hash + term.hashCode();
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        FixedBitSet result = null;
        TermDocs td = reader.termDocs();
        try {
            int[] docs = new int[32];
            int[] freqs = new int[32];
            for (Term term : this.terms) {
                td.seek(term);
                int number = td.read(docs, freqs);
                if (number <= 0) continue;
                if (result == null) {
                    result = new FixedBitSet(reader.maxDoc());
                }
                while (number > 0) {
                    for (int i = 0; i < number; ++i) {
                        result.set(docs[i]);
                    }
                    number = td.read(docs, freqs);
                }
            }
        }
        finally {
            td.close();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Term term : this.terms) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(term);
        }
        return builder.toString();
    }
}

