/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class AnalyzeRequest
extends SingleCustomOperationRequest {
    private String index;
    private String text;
    private String analyzer;
    private String tokenizer;
    private String[] tokenFilters;
    private String field;

    AnalyzeRequest() {
    }

    public AnalyzeRequest(String text) {
        this.text = text;
    }

    public AnalyzeRequest(@Nullable String index, String text) {
        this.index = index;
        this.text = text;
    }

    public String text() {
        return this.text;
    }

    public AnalyzeRequest index(String index) {
        this.index = index;
        return this;
    }

    public String index() {
        return this.index;
    }

    public AnalyzeRequest analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public AnalyzeRequest tokenizer(String tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    public String tokenizer() {
        return this.tokenizer;
    }

    public AnalyzeRequest tokenFilters(String ... tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    public String[] tokenFilters() {
        return this.tokenFilters;
    }

    public AnalyzeRequest field(String field) {
        this.field = field;
        return this;
    }

    public String field() {
        return this.field;
    }

    @Override
    public AnalyzeRequest preferLocal(boolean preferLocal) {
        super.preferLocal(preferLocal);
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.text == null) {
            validationException = ValidateActions.addValidationError("text is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readOptionalUTF();
        this.text = in.readUTF();
        this.analyzer = in.readOptionalUTF();
        this.tokenizer = in.readOptionalUTF();
        int size = in.readVInt();
        if (size > 0) {
            this.tokenFilters = new String[size];
            for (int i = 0; i < size; ++i) {
                this.tokenFilters[i] = in.readUTF();
            }
        }
        this.field = in.readOptionalUTF();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalUTF(this.index);
        out.writeUTF(this.text);
        out.writeOptionalUTF(this.analyzer);
        out.writeOptionalUTF(this.tokenizer);
        if (this.tokenFilters == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.tokenFilters.length);
            for (String tokenFilter : this.tokenFilters) {
                out.writeUTF(tokenFilter);
            }
        }
        out.writeOptionalUTF(this.field);
    }
}

