/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.indices.settings.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.UpdateSettingsResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.MetaDataUpdateSettingsService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateSettingsAction
extends TransportMasterNodeOperationAction<UpdateSettingsRequest, UpdateSettingsResponse> {
    private final MetaDataUpdateSettingsService updateSettingsService;

    @Inject
    public TransportUpdateSettingsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataUpdateSettingsService updateSettingsService) {
        super(settings, transportService, clusterService, threadPool);
        this.updateSettingsService = updateSettingsService;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected String transportAction() {
        return "indices/settings/update";
    }

    @Override
    protected UpdateSettingsRequest newRequest() {
        return new UpdateSettingsRequest();
    }

    @Override
    protected UpdateSettingsResponse newResponse() {
        return new UpdateSettingsResponse();
    }

    @Override
    protected UpdateSettingsResponse masterOperation(UpdateSettingsRequest request, ClusterState state) throws ElasticSearchException {
        final AtomicReference<InterruptedException> failureRef = new AtomicReference<InterruptedException>();
        final CountDownLatch latch = new CountDownLatch(1);
        this.updateSettingsService.updateSettings(request.settings(), request.indices(), new MetaDataUpdateSettingsService.Listener(){

            @Override
            public void onSuccess() {
                latch.countDown();
            }

            @Override
            public void onFailure(Throwable t) {
                failureRef.set(t);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            failureRef.set(e);
        }
        if (failureRef.get() != null) {
            if (failureRef.get() instanceof ElasticSearchException) {
                throw (ElasticSearchException)failureRef.get();
            }
            throw new ElasticSearchException(((Throwable)failureRef.get()).getMessage(), (Throwable)failureRef.get());
        }
        return new UpdateSettingsResponse();
    }
}

