/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.util.Iterator;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.index.shard.ShardId;

public class IndexShardStats
implements Iterable<ShardStats> {
    private final ShardId shardId;
    private final ShardStats[] shards;
    private CommonStats total = null;
    private CommonStats primary = null;

    IndexShardStats(ShardId shardId, ShardStats[] shards) {
        this.shardId = shardId;
        this.shards = shards;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public ShardId getShardId() {
        return this.shardId();
    }

    public ShardStats[] shards() {
        return this.shards;
    }

    public ShardStats[] getShards() {
        return this.shards;
    }

    public ShardStats getAt(int position) {
        return this.shards[position];
    }

    @Override
    public Iterator<ShardStats> iterator() {
        return Iterators.forArray(this.shards);
    }

    public CommonStats total() {
        if (this.total != null) {
            return this.total;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            stats.add(shard.stats());
        }
        this.total = stats;
        return stats;
    }

    public CommonStats primary() {
        if (this.primary != null) {
            return this.primary;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            if (!shard.shardRouting().primary()) continue;
            stats.add(shard.stats());
        }
        this.primary = stats;
        return stats;
    }
}

