/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class ShardValidateQueryResponse
extends BroadcastShardOperationResponse {
    private boolean valid;
    private String explanation;
    private String error;

    ShardValidateQueryResponse() {
    }

    public ShardValidateQueryResponse(String index, int shardId, boolean valid, String explanation, String error) {
        super(index, shardId);
        this.valid = valid;
        this.explanation = explanation;
        this.error = error;
    }

    public boolean valid() {
        return this.valid;
    }

    public String explanation() {
        return this.explanation;
    }

    public String error() {
        return this.error;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.valid = in.readBoolean();
        this.explanation = in.readOptionalUTF();
        this.error = in.readOptionalUTF();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.valid);
        out.writeOptionalUTF(this.explanation);
        out.writeOptionalUTF(this.error);
    }
}

