/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.percolator.PercolatorExecutor;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportShardBulkAction
extends TransportShardReplicationOperationAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    private final MappingUpdatedAction mappingUpdatedAction;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction) {
        super(settings, transportService, clusterService, indicesService, threadPool, shardStateAction);
        this.mappingUpdatedAction = mappingUpdatedAction;
    }

    @Override
    protected String executor() {
        return "bulk";
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected TransportRequestOptions transportOptions() {
        return BulkAction.INSTANCE.transportOptions(this.settings);
    }

    @Override
    protected BulkShardRequest newRequestInstance() {
        return new BulkShardRequest();
    }

    @Override
    protected BulkShardRequest newReplicaRequestInstance() {
        return new BulkShardRequest();
    }

    @Override
    protected BulkShardResponse newResponseInstance() {
        return new BulkShardResponse();
    }

    @Override
    protected String transportAction() {
        return "bulk/shard";
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, BulkShardRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, BulkShardRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, BulkShardRequest request) {
        return clusterState.routingTable().index(request.index()).shard(request.shardId()).shardsIt();
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<BulkShardResponse, BulkShardRequest> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.PrimaryOperationRequest shardRequest) {
        BulkShardRequest request = (BulkShardRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(((BulkShardRequest)shardRequest.request).index()).shardSafe(shardRequest.shardId);
        Engine.IndexingOperation[] ops = null;
        HashSet<Tuple<String, String>> mappingsToUpdate = null;
        BulkItemResponse[] responses = new BulkItemResponse[request.items().length];
        for (int i = 0; i < request.items().length; ++i) {
            BulkItemRequest bulkItemRequest = request.items()[i];
            if (bulkItemRequest.request() instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)bulkItemRequest.request();
                try {
                    Engine.IndexingOperation op;
                    long version;
                    MappingMetaData mappingMd = clusterState.metaData().index(request.index()).mappingOrDefault(indexRequest.type());
                    if (mappingMd != null && mappingMd.routing().required() && indexRequest.routing() == null) {
                        throw new RoutingMissingException(indexRequest.index(), indexRequest.type(), indexRequest.id());
                    }
                    SourceToParse sourceToParse = SourceToParse.source(indexRequest.underlyingSource(), indexRequest.underlyingSourceOffset(), indexRequest.underlyingSourceLength()).type(indexRequest.type()).id(indexRequest.id()).routing(indexRequest.routing()).parent(indexRequest.parent()).timestamp(indexRequest.timestamp()).ttl(indexRequest.ttl());
                    if (indexRequest.opType() == IndexRequest.OpType.INDEX) {
                        Engine.Index index = indexShard.prepareIndex(sourceToParse).version(indexRequest.version()).versionType(indexRequest.versionType()).origin(Engine.Operation.Origin.PRIMARY);
                        indexShard.index(index);
                        version = index.version();
                        op = index;
                    } else {
                        Engine.Create create = indexShard.prepareCreate(sourceToParse).version(indexRequest.version()).versionType(indexRequest.versionType()).origin(Engine.Operation.Origin.PRIMARY);
                        indexShard.create(create);
                        version = create.version();
                        op = create;
                    }
                    indexRequest.version(version);
                    if (op.parsedDoc().mappersAdded()) {
                        if (mappingsToUpdate == null) {
                            mappingsToUpdate = Sets.newHashSet();
                        }
                        mappingsToUpdate.add(Tuple.tuple(indexRequest.index(), indexRequest.type()));
                    }
                    if (Strings.hasLength(indexRequest.percolate())) {
                        if (ops == null) {
                            ops = new Engine.IndexingOperation[request.items().length];
                        }
                        ops[i] = op;
                    }
                    responses[i] = new BulkItemResponse(bulkItemRequest.id(), indexRequest.opType().toString().toLowerCase(Locale.ENGLISH), new IndexResponse(indexRequest.index(), indexRequest.type(), indexRequest.id(), version));
                }
                catch (Exception e) {
                    if (this.retryPrimaryException(e)) {
                        throw (ElasticSearchException)e;
                    }
                    if (e instanceof ElasticSearchException && ((ElasticSearchException)e).status() == RestStatus.CONFLICT) {
                        this.logger.trace("[{}][{}] failed to execute bulk item (index) {}", e, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, indexRequest);
                    } else {
                        this.logger.debug("[{}][{}] failed to execute bulk item (index) {}", e, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, indexRequest);
                    }
                    responses[i] = new BulkItemResponse(bulkItemRequest.id(), indexRequest.opType().toString().toLowerCase(Locale.ENGLISH), new BulkItemResponse.Failure(indexRequest.index(), indexRequest.type(), indexRequest.id(), ExceptionsHelper.detailedMessage(e)));
                    request.items()[i] = null;
                }
                continue;
            }
            if (!(bulkItemRequest.request() instanceof DeleteRequest)) continue;
            DeleteRequest deleteRequest = (DeleteRequest)bulkItemRequest.request();
            try {
                Engine.Delete delete = indexShard.prepareDelete(deleteRequest.type(), deleteRequest.id(), deleteRequest.version()).versionType(deleteRequest.versionType()).origin(Engine.Operation.Origin.PRIMARY);
                indexShard.delete(delete);
                deleteRequest.version(delete.version());
                responses[i] = new BulkItemResponse(bulkItemRequest.id(), "delete", new DeleteResponse(deleteRequest.index(), deleteRequest.type(), deleteRequest.id(), delete.version(), delete.notFound()));
                continue;
            }
            catch (Exception e) {
                if (this.retryPrimaryException(e)) {
                    throw (ElasticSearchException)e;
                }
                if (e instanceof ElasticSearchException && ((ElasticSearchException)e).status() == RestStatus.CONFLICT) {
                    this.logger.trace("[{}][{}] failed to execute bulk item (delete) {}", e, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, deleteRequest);
                } else {
                    this.logger.debug("[{}][{}] failed to execute bulk item (delete) {}", e, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, deleteRequest);
                }
                responses[i] = new BulkItemResponse(bulkItemRequest.id(), "delete", new BulkItemResponse.Failure(deleteRequest.index(), deleteRequest.type(), deleteRequest.id(), ExceptionsHelper.detailedMessage(e)));
                request.items()[i] = null;
            }
        }
        if (mappingsToUpdate != null) {
            for (Tuple tuple : mappingsToUpdate) {
                this.updateMappingOnMaster((String)tuple.v1(), (String)tuple.v2());
            }
        }
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        BulkShardResponse response = new BulkShardResponse(new ShardId(request.index(), request.shardId()), responses);
        return new TransportShardReplicationOperationAction.PrimaryResponse<BulkShardResponse, BulkShardRequest>((BulkShardRequest)shardRequest.request, response, ops);
    }

    @Override
    protected void postPrimaryOperation(BulkShardRequest request, TransportShardReplicationOperationAction.PrimaryResponse<BulkShardResponse, BulkShardRequest> response) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        Engine.IndexingOperation[] ops = (Engine.IndexingOperation[])response.payload();
        if (ops == null) {
            return;
        }
        for (int i = 0; i < ops.length; ++i) {
            IndexRequest indexRequest;
            Engine.IndexingOperation op;
            BulkItemRequest itemRequest = request.items()[i];
            BulkItemResponse itemResponse = response.response().responses()[i];
            if (itemResponse.failed() || (op = ops[i]) == null || !(itemRequest.request() instanceof IndexRequest) || !Strings.hasLength((indexRequest = (IndexRequest)itemRequest.request()).percolate())) continue;
            try {
                PercolatorExecutor.Response percolate = indexService.percolateService().percolate(new PercolatorExecutor.DocAndSourceQueryRequest(op.parsedDoc(), indexRequest.percolate()));
                ((IndexResponse)itemResponse.response()).matches(percolate.matches());
                continue;
            }
            catch (Exception e) {
                this.logger.warn("failed to percolate [{}]", e, itemRequest.request());
            }
        }
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ReplicaOperationRequest shardRequest) {
        IndexShard indexShard = this.indicesService.indexServiceSafe(((BulkShardRequest)shardRequest.request).index()).shardSafe(shardRequest.shardId);
        BulkShardRequest request = (BulkShardRequest)shardRequest.request;
        for (int i = 0; i < request.items().length; ++i) {
            BulkItemRequest item = request.items()[i];
            if (item == null) continue;
            if (item.request() instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)item.request();
                try {
                    SourceToParse sourceToParse = SourceToParse.source(indexRequest.underlyingSource(), indexRequest.underlyingSourceOffset(), indexRequest.underlyingSourceLength()).type(indexRequest.type()).id(indexRequest.id()).routing(indexRequest.routing()).parent(indexRequest.parent()).timestamp(indexRequest.timestamp()).ttl(indexRequest.ttl());
                    if (indexRequest.opType() == IndexRequest.OpType.INDEX) {
                        Engine.Index index = indexShard.prepareIndex(sourceToParse).version(indexRequest.version()).origin(Engine.Operation.Origin.REPLICA);
                        indexShard.index(index);
                        continue;
                    }
                    Engine.Create create = indexShard.prepareCreate(sourceToParse).version(indexRequest.version()).origin(Engine.Operation.Origin.REPLICA);
                    indexShard.create(create);
                }
                catch (Exception e) {}
                continue;
            }
            if (!(item.request() instanceof DeleteRequest)) continue;
            DeleteRequest deleteRequest = (DeleteRequest)item.request();
            try {
                Engine.Delete delete = indexShard.prepareDelete(deleteRequest.type(), deleteRequest.id(), deleteRequest.version()).origin(Engine.Operation.Origin.REPLICA);
                indexShard.delete(delete);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void updateMappingOnMaster(final String index, final String type) {
        try {
            MapperService mapperService = this.indicesService.indexServiceSafe(index).mapperService();
            final DocumentMapper documentMapper = mapperService.documentMapper(type);
            if (documentMapper == null) {
                return;
            }
            documentMapper.refreshSource();
            this.mappingUpdatedAction.execute(new MappingUpdatedAction.MappingUpdatedRequest(index, type, documentMapper.mappingSource()), new ActionListener<MappingUpdatedAction.MappingUpdatedResponse>(){

                @Override
                public void onResponse(MappingUpdatedAction.MappingUpdatedResponse mappingUpdatedResponse) {
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        TransportShardBulkAction.this.logger.warn("failed to update master on updated mapping for index [{}], type [{}] and source [{}]", e, index, type, documentMapper.mappingSource().string());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("failed to update master on updated mapping for index [{}], type [{}]", e, index, type);
        }
    }
}

