/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportService;

public abstract class TransportMasterNodeOperationAction<Request extends MasterNodeOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    final String transportAction;
    final String executor;

    protected TransportMasterNodeOperationAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, threadPool);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.transportAction = this.transportAction();
        this.executor = this.executor();
        transportService.registerHandler(this.transportAction, new TransportHandler());
    }

    protected abstract String transportAction();

    protected abstract String executor();

    protected abstract Request newRequest();

    protected abstract Response newResponse();

    protected abstract Response masterOperation(Request var1, ClusterState var2) throws ElasticSearchException;

    protected boolean localExecute(Request request) {
        return false;
    }

    protected ClusterBlockException checkBlock(Request request, ClusterState state) {
        return null;
    }

    protected void processBeforeDelegationToMaster(Request request, ClusterState state) {
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        this.innerExecute(request, listener, false);
    }

    private void innerExecute(Request request, final ActionListener<Response> listener, boolean retrying) {
        ClusterState clusterState = this.clusterService.state();
        DiscoveryNodes nodes = clusterState.nodes();
        if (nodes.localNodeMaster() || this.localExecute(request)) {
            ClusterBlockException blockException = this.checkBlock(request, clusterState);
            if (blockException != null) {
                if (!blockException.retryable()) {
                    listener.onFailure(blockException);
                    return;
                }
                this.clusterService.add(((MasterNodeOperationRequest)request).masterNodeTimeout(), new TimeoutClusterStateListener((MasterNodeOperationRequest)request, listener, blockException){
                    final /* synthetic */ MasterNodeOperationRequest val$request;
                    final /* synthetic */ ActionListener val$listener;
                    final /* synthetic */ ClusterBlockException val$blockException;
                    {
                        this.val$request = masterNodeOperationRequest;
                        this.val$listener = actionListener;
                        this.val$blockException = clusterBlockException;
                    }

                    @Override
                    public void postAdded() {
                        ClusterBlockException blockException = TransportMasterNodeOperationAction.this.checkBlock(this.val$request, TransportMasterNodeOperationAction.this.clusterService.state());
                        if (blockException == null || !blockException.retryable()) {
                            TransportMasterNodeOperationAction.this.clusterService.remove(this);
                            TransportMasterNodeOperationAction.this.innerExecute(this.val$request, this.val$listener, false);
                        }
                    }

                    @Override
                    public void onClose() {
                        TransportMasterNodeOperationAction.this.clusterService.remove(this);
                        this.val$listener.onFailure(this.val$blockException);
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        TransportMasterNodeOperationAction.this.clusterService.remove(this);
                        this.val$listener.onFailure(this.val$blockException);
                    }

                    @Override
                    public void clusterChanged(ClusterChangedEvent event) {
                        ClusterBlockException blockException = TransportMasterNodeOperationAction.this.checkBlock(this.val$request, event.state());
                        if (blockException == null || !blockException.retryable()) {
                            TransportMasterNodeOperationAction.this.clusterService.remove(this);
                            TransportMasterNodeOperationAction.this.innerExecute(this.val$request, this.val$listener, false);
                        }
                    }
                });
            } else {
                this.threadPool.executor(this.executor).execute(new Runnable((MasterNodeOperationRequest)request, clusterState, listener){
                    final /* synthetic */ MasterNodeOperationRequest val$request;
                    final /* synthetic */ ClusterState val$clusterState;
                    final /* synthetic */ ActionListener val$listener;
                    {
                        this.val$request = masterNodeOperationRequest;
                        this.val$clusterState = clusterState;
                        this.val$listener = actionListener;
                    }

                    @Override
                    public void run() {
                        try {
                            Object response = TransportMasterNodeOperationAction.this.masterOperation(this.val$request, this.val$clusterState);
                            this.val$listener.onResponse(response);
                        }
                        catch (Exception e) {
                            this.val$listener.onFailure(e);
                        }
                    }
                });
            }
        } else {
            if (nodes.masterNode() == null) {
                if (retrying) {
                    listener.onFailure(new MasterNotDiscoveredException());
                } else {
                    this.clusterService.add(((MasterNodeOperationRequest)request).masterNodeTimeout(), new TimeoutClusterStateListener((MasterNodeOperationRequest)request, listener, nodes){
                        final /* synthetic */ MasterNodeOperationRequest val$request;
                        final /* synthetic */ ActionListener val$listener;
                        final /* synthetic */ DiscoveryNodes val$nodes;
                        {
                            this.val$request = masterNodeOperationRequest;
                            this.val$listener = actionListener;
                            this.val$nodes = discoveryNodes;
                        }

                        @Override
                        public void postAdded() {
                            ClusterState clusterStateV2 = TransportMasterNodeOperationAction.this.clusterService.state();
                            if (clusterStateV2.nodes().masterNodeId() != null) {
                                TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                TransportMasterNodeOperationAction.this.innerExecute(this.val$request, this.val$listener, true);
                            }
                        }

                        @Override
                        public void onClose() {
                            TransportMasterNodeOperationAction.this.clusterService.remove(this);
                            this.val$listener.onFailure(new NodeClosedException(this.val$nodes.localNode()));
                        }

                        @Override
                        public void onTimeout(TimeValue timeout) {
                            TransportMasterNodeOperationAction.this.clusterService.remove(this);
                            this.val$listener.onFailure(new MasterNotDiscoveredException("waited for [" + timeout + "]"));
                        }

                        @Override
                        public void clusterChanged(ClusterChangedEvent event) {
                            if (event.nodesDelta().masterNodeChanged()) {
                                TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                TransportMasterNodeOperationAction.this.innerExecute(this.val$request, this.val$listener, true);
                            }
                        }
                    });
                }
                return;
            }
            this.processBeforeDelegationToMaster(request, clusterState);
            this.transportService.sendRequest(nodes.masterNode(), this.transportAction, (Streamable)request, new BaseTransportResponseHandler<Response>((MasterNodeOperationRequest)request, clusterState, nodes){
                final /* synthetic */ MasterNodeOperationRequest val$request;
                final /* synthetic */ ClusterState val$clusterState;
                final /* synthetic */ DiscoveryNodes val$nodes;
                {
                    this.val$request = masterNodeOperationRequest;
                    this.val$clusterState = clusterState;
                    this.val$nodes = discoveryNodes;
                }

                @Override
                public Response newInstance() {
                    return TransportMasterNodeOperationAction.this.newResponse();
                }

                @Override
                public void handleResponse(Response response) {
                    listener.onResponse(response);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleException(TransportException exp) {
                    if (exp.unwrapCause() instanceof ConnectTransportException) {
                        TransportMasterNodeOperationAction.this.clusterService.add(this.val$request.masterNodeTimeout(), new TimeoutClusterStateListener(){

                            @Override
                            public void postAdded() {
                                ClusterState clusterStateV2 = TransportMasterNodeOperationAction.this.clusterService.state();
                                if (!val$clusterState.nodes().masterNodeId().equals(clusterStateV2.nodes().masterNodeId())) {
                                    TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                    TransportMasterNodeOperationAction.this.innerExecute(val$request, listener, false);
                                }
                            }

                            @Override
                            public void onClose() {
                                TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                listener.onFailure(new NodeClosedException(val$nodes.localNode()));
                            }

                            @Override
                            public void onTimeout(TimeValue timeout) {
                                TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                listener.onFailure(new MasterNotDiscoveredException());
                            }

                            @Override
                            public void clusterChanged(ClusterChangedEvent event) {
                                if (event.nodesDelta().masterNodeChanged()) {
                                    TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                    TransportMasterNodeOperationAction.this.innerExecute(val$request, listener, false);
                                }
                            }
                        });
                    } else {
                        listener.onFailure(exp);
                    }
                }
            });
        }
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportMasterNodeOperationAction.this.newRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((MasterNodeOperationRequest)request).listenerThreaded(false);
            TransportMasterNodeOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    try {
                        channel.sendResponse((Streamable)response);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportMasterNodeOperationAction.this.logger.warn("Failed to send response", e1, new Object[0]);
                    }
                }
            });
        }
    }
}

