/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cache;

import org.elasticsearch.cache.memory.ByteBufferCache;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class NodeCache
extends AbstractComponent
implements ClusterStateListener {
    private final ClusterService clusterService;
    private final ByteBufferCache byteBufferCache;

    @Inject
    public NodeCache(Settings settings, ByteBufferCache byteBufferCache, ClusterService clusterService) {
        super(settings);
        this.clusterService = clusterService;
        this.byteBufferCache = byteBufferCache;
        clusterService.add(this);
    }

    public void close() {
        this.clusterService.remove(this);
        this.byteBufferCache.close();
    }

    public ByteBufferCache byteBuffer() {
        return this.byteBufferCache;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
    }
}

