/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.VoidStreamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.VoidTransportResponseHandler;

public class NodeMappingCreatedAction
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    @Inject
    public NodeMappingCreatedAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterService = clusterService;
        transportService.registerHandler("cluster/nodeMappingCreated", new NodeMappingCreatedTransportHandler());
    }

    public void add(final Listener listener, TimeValue timeout) {
        this.listeners.add(listener);
        this.threadPool.schedule(timeout, "generic", new Runnable(){

            @Override
            public void run() {
                boolean removed = NodeMappingCreatedAction.this.listeners.remove(listener);
                if (removed) {
                    listener.onTimeout();
                }
            }
        });
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    public void nodeMappingCreated(final NodeMappingCreatedResponse response) throws ElasticSearchException {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        if (nodes.localNodeMaster()) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    NodeMappingCreatedAction.this.innerNodeIndexCreated(response);
                }
            });
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), "cluster/nodeMappingCreated", response, VoidTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private void innerNodeIndexCreated(NodeMappingCreatedResponse response) {
        for (Listener listener : this.listeners) {
            listener.onNodeMappingCreated(response);
        }
    }

    public static class NodeMappingCreatedResponse
    implements Streamable {
        private String index;
        private String type;
        private String nodeId;

        private NodeMappingCreatedResponse() {
        }

        public NodeMappingCreatedResponse(String index, String type, String nodeId) {
            this.index = index;
            this.type = type;
            this.nodeId = nodeId;
        }

        public String index() {
            return this.index;
        }

        public String type() {
            return this.type;
        }

        public String nodeId() {
            return this.nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.index);
            out.writeUTF(this.type);
            out.writeUTF(this.nodeId);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.index = in.readUTF();
            this.type = in.readUTF();
            this.nodeId = in.readUTF();
        }
    }

    private class NodeMappingCreatedTransportHandler
    extends BaseTransportRequestHandler<NodeMappingCreatedResponse> {
        static final String ACTION = "cluster/nodeMappingCreated";

        private NodeMappingCreatedTransportHandler() {
        }

        @Override
        public NodeMappingCreatedResponse newInstance() {
            return new NodeMappingCreatedResponse();
        }

        @Override
        public void messageReceived(NodeMappingCreatedResponse response, TransportChannel channel) throws Exception {
            NodeMappingCreatedAction.this.innerNodeIndexCreated(response);
            channel.sendResponse(VoidStreamable.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    public static interface Listener {
        public void onNodeMappingCreated(NodeMappingCreatedResponse var1);

        public void onTimeout();
    }
}

