/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.VoidStreamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.VoidTransportResponseHandler;

public class NodeMappingRefreshAction
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final MetaDataMappingService metaDataMappingService;

    @Inject
    public NodeMappingRefreshAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, MetaDataMappingService metaDataMappingService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.metaDataMappingService = metaDataMappingService;
        transportService.registerHandler("cluster/nodeMappingRefresh", new NodeMappingRefreshTransportHandler());
    }

    public void nodeMappingRefresh(final NodeMappingRefreshRequest request) throws ElasticSearchException {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        if (nodes.localNodeMaster()) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    NodeMappingRefreshAction.this.innerMappingRefresh(request);
                }
            });
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), "cluster/nodeMappingRefresh", request, VoidTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private void innerMappingRefresh(NodeMappingRefreshRequest request) {
        this.metaDataMappingService.refreshMapping(request.index(), request.types());
    }

    public static class NodeMappingRefreshRequest
    implements Streamable {
        private String index;
        private String[] types;
        private String nodeId;

        private NodeMappingRefreshRequest() {
        }

        public NodeMappingRefreshRequest(String index, String[] types, String nodeId) {
            this.index = index;
            this.types = types;
            this.nodeId = nodeId;
        }

        public String index() {
            return this.index;
        }

        public String[] types() {
            return this.types;
        }

        public String nodeId() {
            return this.nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.index);
            out.writeVInt(this.types.length);
            for (String type : this.types) {
                out.writeUTF(type);
            }
            out.writeUTF(this.nodeId);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.index = in.readUTF();
            this.types = new String[in.readVInt()];
            for (int i = 0; i < this.types.length; ++i) {
                this.types[i] = in.readUTF();
            }
            this.nodeId = in.readUTF();
        }
    }

    private class NodeMappingRefreshTransportHandler
    extends BaseTransportRequestHandler<NodeMappingRefreshRequest> {
        static final String ACTION = "cluster/nodeMappingRefresh";

        private NodeMappingRefreshTransportHandler() {
        }

        @Override
        public NodeMappingRefreshRequest newInstance() {
            return new NodeMappingRefreshRequest();
        }

        @Override
        public void messageReceived(NodeMappingRefreshRequest request, TransportChannel channel) throws Exception {
            NodeMappingRefreshAction.this.innerMappingRefresh(request);
            channel.sendResponse(VoidStreamable.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

