/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bloom;

import java.io.UnsupportedEncodingException;
import org.elasticsearch.common.UUID;
import org.elasticsearch.common.bloom.BloomCalculations;
import org.elasticsearch.common.bloom.BloomFilter;
import org.elasticsearch.common.bloom.ObsBloomFilter;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.unit.TimeValue;

public class BloomFilterFactory {
    private static ESLogger logger = ESLoggerFactory.getLogger(BloomFilterFactory.class.getName());
    private static final int EXCESS = 20;

    public static BloomFilter getFilter(long numElements, int targetBucketsPerElem) {
        int maxBucketsPerElement = Math.max(1, BloomCalculations.maxBucketsPerElement(numElements));
        int bucketsPerElement = Math.min(targetBucketsPerElem, maxBucketsPerElement);
        if (bucketsPerElement < targetBucketsPerElem) {
            logger.warn(String.format("Cannot provide an optimal BloomFilter for %d elements (%d/%d buckets per element).", numElements, bucketsPerElement, targetBucketsPerElem), new Object[0]);
        }
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement);
        return new ObsBloomFilter(spec.K, BloomFilterFactory.bucketsFor(numElements, spec.bucketsPerElement));
    }

    public static BloomFilter getFilter(long numElements, double maxFalsePosProbability) {
        assert (maxFalsePosProbability <= 1.0) : "Invalid probability";
        int bucketsPerElement = BloomCalculations.maxBucketsPerElement(numElements);
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement, maxFalsePosProbability);
        return new ObsBloomFilter(spec.K, BloomFilterFactory.bucketsFor(numElements, spec.bucketsPerElement));
    }

    private static long bucketsFor(long numElements, int bucketsPer) {
        return numElements * (long)bucketsPer + 20L;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        byte[] utf8s;
        long elements = SizeValue.parseSizeValue("100m").singles();
        BloomFilter filter = BloomFilterFactory.getFilter(elements, 15);
        System.out.println("Filter size: " + new ByteSizeValue(filter.sizeInBytes()));
        for (long i = 0L; i < elements; ++i) {
            utf8s = UUID.randomBase64UUID().getBytes("UTF8");
            filter.add(utf8s, 0, utf8s.length);
        }
        long falsePositives = 0L;
        for (long i = 0L; i < elements; ++i) {
            byte[] utf8s2 = UUID.randomBase64UUID().getBytes("UTF8");
            if (!filter.isPresent(utf8s2, 0, utf8s2.length)) continue;
            ++falsePositives;
        }
        System.out.println("false positives: " + falsePositives);
        utf8s = UUID.randomBase64UUID().getBytes("UTF8");
        long time = System.currentTimeMillis();
        for (long i = 0L; i < elements; ++i) {
            if (!filter.isPresent(utf8s, 0, utf8s.length)) continue;
        }
        long timeSize = System.currentTimeMillis() - time;
        System.out.println("Indexed in " + new TimeValue(timeSize) + ", TPS: " + elements / timeSize + " per millisecond");
    }
}

