/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.lang.reflect.Array;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.annotations.GwtIncompatible;
import org.elasticsearch.common.collect.MapMaker;

@GwtCompatible(emulated=true)
class Platform {
    static <T> T[] clone(T[] array) {
        return (Object[])array.clone();
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    static <T> T[] newArray(T[] reference, int length) {
        Class<?> type = reference.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(type, length);
        return result;
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    private Platform() {
    }
}

