/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class CompressedStreamOutput
extends StreamOutput {
    private final StreamOutput out;
    protected byte[] uncompressed;
    private int position = 0;
    private boolean closed;

    public CompressedStreamOutput(StreamOutput out) throws IOException {
        this.out = out;
        this.writeHeader(out);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.position >= this.uncompressed.length) {
            this.flushBuffer();
        }
        this.uncompressed[this.position++] = (byte)b;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        if (this.position >= this.uncompressed.length) {
            this.flushBuffer();
        }
        this.uncompressed[this.position++] = b;
    }

    @Override
    public void writeBytes(byte[] input, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int BUFFER_LEN = this.uncompressed.length;
        int free = BUFFER_LEN - this.position;
        if (free >= length) {
            System.arraycopy(input, offset, this.uncompressed, this.position, length);
            this.position += length;
            return;
        }
        if (this.position > 0) {
            System.arraycopy(input, offset, this.uncompressed, this.position, free);
            this.position += free;
            this.flushBuffer();
            offset += free;
            length -= free;
        }
        while (length >= BUFFER_LEN) {
            this.compress(input, offset, BUFFER_LEN, this.out);
            offset += BUFFER_LEN;
            length -= BUFFER_LEN;
        }
        if (length > 0) {
            System.arraycopy(input, offset, this.uncompressed, 0, length);
        }
        this.position = length;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flushBuffer();
            this.closed = true;
            this.doClose();
            this.out.close();
        }
    }

    protected abstract void doClose() throws IOException;

    @Override
    public void reset() throws IOException {
        this.position = 0;
        this.out.reset();
    }

    private void flushBuffer() throws IOException {
        if (this.position > 0) {
            this.compress(this.uncompressed, 0, this.position, this.out);
            this.position = 0;
        }
    }

    protected abstract void writeHeader(StreamOutput var1) throws IOException;

    protected abstract void compress(byte[] var1, int var2, int var3, StreamOutput var4) throws IOException;
}

