/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.common.BytesHolder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.joda.time.DateTime;

public abstract class StreamInput
extends InputStream {
    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public BytesHolder readBytesHolder() throws IOException {
        int size = this.readVInt();
        if (size == 0) {
            return BytesHolder.EMPTY;
        }
        byte[] bytes = new byte[size];
        this.readBytes(bytes, 0, size);
        return new BytesHolder(bytes, 0, size);
    }

    public BytesHolder readBytesReference() throws IOException {
        return this.readBytesHolder();
    }

    public void readFully(byte[] b) throws IOException {
        this.readBytes(b, 0, b.length);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        assert ((b & 0x80) == 0);
        return i | (b & 0x7F) << 28;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        assert ((b & 0x80) == 0);
        return i | ((long)b & 0x7FL) << 56;
    }

    @Nullable
    public String readOptionalUTF() throws IOException {
        if (this.readBoolean()) {
            return this.readUTF();
        }
        return null;
    }

    public String readUTF() throws IOException {
        int charCount = this.readVInt();
        char[] chars = CachedStreamInput.getCharArray(charCount);
        int charIndex = 0;
        while (charIndex < charCount) {
            int c = this.readByte() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    chars[charIndex++] = (char)((c & 0x1F) << 6 | this.readByte() & 0x3F);
                    break;
                }
                case 14: {
                    chars[charIndex++] = (char)((c & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | (this.readByte() & 0x3F) << 0);
                }
            }
        }
        return new String(chars, 0, charCount);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public abstract void reset() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Nullable
    public Map<String, Object> readMap() throws IOException {
        return (Map)this.readGenericValue();
    }

    @Nullable
    public Object readGenericValue() throws IOException {
        byte type = this.readByte();
        if (type == -1) {
            return null;
        }
        if (type == 0) {
            return this.readUTF();
        }
        if (type == 1) {
            return this.readInt();
        }
        if (type == 2) {
            return this.readLong();
        }
        if (type == 3) {
            return Float.valueOf(this.readFloat());
        }
        if (type == 4) {
            return this.readDouble();
        }
        if (type == 5) {
            return this.readBoolean();
        }
        if (type == 6) {
            int bytesSize = this.readVInt();
            byte[] value = new byte[bytesSize];
            this.readFully(value);
            return value;
        }
        if (type == 7) {
            int size = this.readVInt();
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                list.add(this.readGenericValue());
            }
            return list;
        }
        if (type == 8) {
            int size = this.readVInt();
            Object[] list = new Object[size];
            for (int i = 0; i < size; ++i) {
                list[i] = this.readGenericValue();
            }
            return list;
        }
        if (type == 9 || type == 10) {
            int size = this.readVInt();
            HashMap map = type == 9 ? new LinkedHashMap(size) : new HashMap(size);
            for (int i = 0; i < size; ++i) {
                map.put(this.readUTF(), this.readGenericValue());
            }
            return map;
        }
        if (type == 11) {
            return this.readByte();
        }
        if (type == 12) {
            return new Date(this.readLong());
        }
        if (type == 13) {
            return new DateTime(this.readLong());
        }
        throw new IOException("Can't read unknown type [" + type + "]");
    }
}

