/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.elasticsearch.common.lucene.docset.DocSet;

public abstract class GetDocSet
extends DocSet {
    private final int maxDoc;

    protected GetDocSet(int maxDoc) {
        this.maxDoc = maxDoc;
    }

    @Override
    public long sizeInBytes() {
        return 0L;
    }

    public int length() {
        return this.maxDoc;
    }

    public DocIdSetIterator iterator() throws IOException {
        return new DocIdSetIterator(){
            private int doc = -1;

            public int docID() {
                return this.doc;
            }

            public int nextDoc() throws IOException {
                do {
                    ++this.doc;
                    if (this.doc < GetDocSet.this.maxDoc) continue;
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                } while (!GetDocSet.this.get(this.doc));
                return this.doc;
            }

            public int advance(int target) throws IOException {
                if (target >= GetDocSet.this.maxDoc) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.doc = target;
                while (!GetDocSet.this.get(this.doc)) {
                    ++this.doc;
                    if (this.doc < GetDocSet.this.maxDoc) continue;
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                return this.doc;
            }
        };
    }
}

