/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lucene.search.MatchNoDocsQuery;

public class MultiPhrasePrefixQuery
extends Query {
    private String field;
    private ArrayList<Term[]> termArrays = new ArrayList();
    private ArrayList<Integer> positions = new ArrayList();
    private int maxExpansions = Integer.MAX_VALUE;
    private int slop = 0;

    public void setSlop(int s) {
        this.slop = s;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        this.add(new Term[]{term});
    }

    public void add(Term[] terms) {
        int position = 0;
        if (this.positions.size() > 0) {
            position = this.positions.get(this.positions.size() - 1) + 1;
        }
        this.add(terms, position);
    }

    public void add(Term[] terms, int position) {
        if (this.termArrays.size() == 0) {
            this.field = terms[0].field();
        }
        for (int i = 0; i < terms.length; ++i) {
            if (terms[i].field() == this.field) continue;
            throw new IllegalArgumentException("All phrase terms must be in the same field (" + this.field + "): " + terms[i]);
        }
        this.termArrays.add(terms);
        this.positions.add(position);
    }

    public List<Term[]> getTermArrays() {
        return Collections.unmodifiableList(this.termArrays);
    }

    public int[] getPositions() {
        int[] result = new int[this.positions.size()];
        for (int i = 0; i < this.positions.size(); ++i) {
            result[i] = this.positions.get(i);
        }
        return result;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.termArrays.isEmpty()) {
            return MatchNoDocsQuery.INSTANCE;
        }
        MultiPhraseQuery query = new MultiPhraseQuery();
        query.setSlop(this.slop);
        int sizeMinus1 = this.termArrays.size() - 1;
        for (int i = 0; i < sizeMinus1; ++i) {
            query.add(this.termArrays.get(i), this.positions.get(i).intValue());
        }
        Term[] suffixTerms = this.termArrays.get(sizeMinus1);
        int position = this.positions.get(sizeMinus1);
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Term term : suffixTerms) {
            this.getPrefixTerms(terms, term, reader);
            if (terms.size() > this.maxExpansions) break;
        }
        if (terms.isEmpty()) {
            return MatchNoDocsQuery.INSTANCE;
        }
        query.add(terms.toArray(new Term[terms.size()]), position);
        return query.rewrite(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPrefixTerms(List<Term> terms, Term prefix, IndexReader reader) throws IOException {
        TermEnum enumerator = reader.terms(prefix);
        try {
            Term term;
            while ((term = enumerator.term()) != null && term.text().startsWith(prefix.text()) && term.field().equals(this.field)) {
                terms.add(term);
                if (terms.size() >= this.maxExpansions) {
                } else if (enumerator.next()) continue;
                break;
            }
        }
        finally {
            enumerator.close();
        }
    }

    public final String toString(String f) {
        StringBuilder buffer = new StringBuilder();
        if (this.field == null || !this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        Iterator<Term[]> i = this.termArrays.iterator();
        while (i.hasNext()) {
            Term[] terms = i.next();
            if (terms.length > 1) {
                buffer.append("(");
                for (int j = 0; j < terms.length; ++j) {
                    buffer.append(terms[j].text());
                    if (j >= terms.length - 1) continue;
                    buffer.append(" ");
                }
                buffer.append(")");
            } else {
                buffer.append(terms[0].text());
            }
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiPhrasePrefixQuery)) {
            return false;
        }
        MultiPhrasePrefixQuery other = (MultiPhrasePrefixQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.slop == other.slop && this.termArraysEquals(this.termArrays, other.termArrays) && this.positions.equals(other.positions);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.slop ^ this.termArraysHashCode() ^ this.positions.hashCode() ^ 0x4AC65113;
    }

    private int termArraysHashCode() {
        int hashCode = 1;
        for (Object[] objectArray : this.termArrays) {
            hashCode = 31 * hashCode + (objectArray == null ? 0 : Arrays.hashCode(objectArray));
        }
        return hashCode;
    }

    private boolean termArraysEquals(List<Term[]> termArrays1, List<Term[]> termArrays2) {
        if (termArrays1.size() != termArrays2.size()) {
            return false;
        }
        ListIterator<Term[]> iterator1 = termArrays1.listIterator();
        ListIterator<Term[]> iterator2 = termArrays2.listIterator();
        while (iterator1.hasNext()) {
            Object[] termArray1 = iterator1.next();
            Object[] termArray2 = iterator2.next();
            if (termArray1 != null ? Arrays.equals(termArray1, termArray2) : termArray2 == null) continue;
            return false;
        }
        return true;
    }
}

