/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class FunctionScoreQuery
extends Query {
    Query subQuery;
    final ScoreFunction function;

    public FunctionScoreQuery(Query subQuery, ScoreFunction function) {
        this.subQuery = subQuery;
        this.function = function;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public ScoreFunction getFunction() {
        return this.function;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        FunctionScoreQuery bq = (FunctionScoreQuery)((Object)this.clone());
        bq.subQuery = newQ;
        return bq;
    }

    public void extractTerms(Set<Term> terms) {
        this.subQuery.extractTerms(terms);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new CustomBoostFactorWeight(searcher);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("custom score (").append(this.subQuery.toString(field)).append(",function=").append(this.function).append(')');
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery other = (FunctionScoreQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.subQuery.equals((Object)other.subQuery) && this.function.equals(other.function);
    }

    public int hashCode() {
        return this.subQuery.hashCode() + 31 * this.function.hashCode() ^ Float.floatToIntBits(this.getBoost());
    }

    static class CustomBoostFactorScorer
    extends Scorer {
        private final float subQueryWeight;
        private final Scorer scorer;
        private final ScoreFunction function;

        private CustomBoostFactorScorer(Similarity similarity, CustomBoostFactorWeight w, Scorer scorer, ScoreFunction function) throws IOException {
            super(similarity);
            this.subQueryWeight = w.getValue();
            this.scorer = scorer;
            this.function = function;
        }

        public int docID() {
            return this.scorer.docID();
        }

        public int advance(int target) throws IOException {
            return this.scorer.advance(target);
        }

        public int nextDoc() throws IOException {
            return this.scorer.nextDoc();
        }

        public float score() throws IOException {
            return this.subQueryWeight * this.function.score(this.scorer.docID(), this.scorer.score());
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        Searcher searcher;
        Weight subQueryWeight;

        public CustomBoostFactorWeight(Searcher searcher) throws IOException {
            this.searcher = searcher;
            this.subQueryWeight = FunctionScoreQuery.this.subQuery.weight(searcher);
        }

        public Query getQuery() {
            return FunctionScoreQuery.this;
        }

        public float getValue() {
            return FunctionScoreQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float sum = this.subQueryWeight.sumOfSquaredWeights();
            return sum *= FunctionScoreQuery.this.getBoost() * FunctionScoreQuery.this.getBoost();
        }

        public void normalize(float norm) {
            this.subQueryWeight.normalize(norm *= FunctionScoreQuery.this.getBoost());
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(reader, scoreDocsInOrder, false);
            if (subQueryScorer == null) {
                return null;
            }
            FunctionScoreQuery.this.function.setNextReader(reader);
            return new CustomBoostFactorScorer(FunctionScoreQuery.this.getSimilarity(this.searcher), this, subQueryScorer, FunctionScoreQuery.this.function);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation subQueryExpl = this.subQueryWeight.explain(reader, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            FunctionScoreQuery.this.function.setNextReader(reader);
            Explanation functionExplanation = FunctionScoreQuery.this.function.explainScore(doc, subQueryExpl);
            float sc = this.getValue() * functionExplanation.getValue();
            ComplexExplanation res = new ComplexExplanation(true, sc, "custom score, product of:");
            res.addDetail(functionExplanation);
            res.addDetail(new Explanation(this.getValue(), "queryBoost"));
            return res;
        }
    }
}

