/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;

public class EsExecutors {
    public static EsThreadPoolExecutor newScalingExecutorService(int min, int max, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        ExecutorScalingQueue<Runnable> queue = new ExecutorScalingQueue<Runnable>();
        EsThreadPoolExecutor executor = new EsThreadPoolExecutor(min, max, keepAliveTime, unit, queue, threadFactory, new ForceQueuePolicy());
        queue.executor = executor;
        return executor;
    }

    public static EsThreadPoolExecutor newBlockingExecutorService(int min, int max, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, int capacity, long waitTime, TimeUnit waitTimeUnit) {
        ExecutorBlockingQueue<Runnable> queue = new ExecutorBlockingQueue<Runnable>(capacity);
        EsThreadPoolExecutor executor = new EsThreadPoolExecutor(min, max, keepAliveTime, unit, queue, threadFactory, new TimedBlockingPolicy(waitTimeUnit.toMillis(waitTime)));
        queue.executor = executor;
        return executor;
    }

    public static String threadName(Settings settings, String namePrefix) {
        String name = settings.get("name");
        name = name == null ? "elasticsearch" : "elasticsearch[" + name + "]";
        return name + "[" + namePrefix + "]";
    }

    public static ThreadFactory daemonThreadFactory(Settings settings, String namePrefix) {
        return EsExecutors.daemonThreadFactory(EsExecutors.threadName(settings, namePrefix));
    }

    public static ThreadFactory daemonThreadFactory(String namePrefix) {
        return new EsThreadFactory(namePrefix);
    }

    private EsExecutors() {
    }

    static class TimedBlockingPolicy
    implements RejectedExecutionHandler {
        private final long waitTime;

        public TimedBlockingPolicy(long waitTime) {
            this.waitTime = waitTime;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                boolean successful = executor.getQueue().offer(r, this.waitTime, TimeUnit.MILLISECONDS);
                if (!successful) {
                    throw new EsRejectedExecutionException();
                }
            }
            catch (InterruptedException e) {
                throw new EsRejectedExecutionException(e);
            }
        }
    }

    static class ForceQueuePolicy
    implements RejectedExecutionHandler {
        ForceQueuePolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new EsRejectedExecutionException(e);
            }
        }
    }

    static class ExecutorBlockingQueue<E>
    extends ArrayBlockingQueue<E> {
        ThreadPoolExecutor executor;

        ExecutorBlockingQueue(int capacity) {
            super(capacity);
        }

        @Override
        public boolean offer(E o) {
            int allWorkingThreads = this.executor.getActiveCount() + super.size();
            return allWorkingThreads < this.executor.getPoolSize() && super.offer(o);
        }
    }

    static class ExecutorScalingQueue<E>
    extends LinkedTransferQueue<E> {
        ThreadPoolExecutor executor;

        @Override
        public boolean offer(E e) {
            int left = this.executor.getMaximumPoolSize() - this.executor.getCorePoolSize();
            if (!this.tryTransfer(e)) {
                if (left > 0) {
                    return false;
                }
                return super.offer(e);
            }
            return true;
        }
    }

    static class EsThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        public EsThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + "[T#" + this.threadNumber.getAndIncrement() + "]", 0L);
            t.setDaemon(true);
            return t;
        }
    }
}

