/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public final class CustomAnalyzer
extends Analyzer {
    private final TokenizerFactory tokenizerFactory;
    private final CharFilterFactory[] charFilters;
    private final TokenFilterFactory[] tokenFilters;
    private final int positionIncrementGap;
    private final int offsetGap;

    public CustomAnalyzer(TokenizerFactory tokenizerFactory, CharFilterFactory[] charFilters, TokenFilterFactory[] tokenFilters) {
        this(tokenizerFactory, charFilters, tokenFilters, 0, -1);
    }

    public CustomAnalyzer(TokenizerFactory tokenizerFactory, CharFilterFactory[] charFilters, TokenFilterFactory[] tokenFilters, int positionOffsetGap, int offsetGap) {
        this.tokenizerFactory = tokenizerFactory;
        this.charFilters = charFilters;
        this.tokenFilters = tokenFilters;
        this.positionIncrementGap = positionOffsetGap;
        this.offsetGap = offsetGap;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.tokenizerFactory;
    }

    public TokenFilterFactory[] tokenFilters() {
        return this.tokenFilters;
    }

    public CharFilterFactory[] charFilters() {
        return this.charFilters;
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.positionIncrementGap;
    }

    public int getOffsetGap(Fieldable field) {
        if (this.offsetGap < 0) {
            return super.getOffsetGap(field);
        }
        return this.offsetGap;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        return this.buildHolder((Reader)reader).tokenStream;
    }

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        Holder holder = (Holder)this.getPreviousTokenStream();
        if (holder == null) {
            holder = this.buildHolder(this.charFilterIfNeeded(reader));
            this.setPreviousTokenStream(holder);
        } else {
            holder.tokenizer.reset(this.charFilterIfNeeded(reader));
        }
        return holder.tokenStream;
    }

    private Holder buildHolder(Reader input) {
        Tokenizer tokenizer;
        Tokenizer tokenStream = tokenizer = this.tokenizerFactory.create(input);
        for (TokenFilterFactory tokenFilter : this.tokenFilters) {
            tokenStream = tokenFilter.create((TokenStream)tokenStream);
        }
        return new Holder(tokenizer, (TokenStream)tokenStream);
    }

    private Reader charFilterIfNeeded(Reader reader) {
        if (this.charFilters != null && this.charFilters.length > 0) {
            CharStream charStream = CharReader.get((Reader)reader);
            for (CharFilterFactory charFilter : this.charFilters) {
                charStream = charFilter.create(charStream);
            }
            reader = charStream;
        }
        return reader;
    }

    static class Holder {
        final Tokenizer tokenizer;
        final TokenStream tokenStream;

        private Holder(Tokenizer tokenizer, TokenStream tokenStream) {
            this.tokenizer = tokenizer;
            this.tokenStream = tokenStream;
        }
    }
}

