/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Collection;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.settings.IndexSettings;

@AnalysisSettingsRequired
public class KeywordMarkerTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet keywordLookup;

    @Inject
    public KeywordMarkerTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        boolean ignoreCase = settings.getAsBoolean("ignore_case", false);
        CharArraySet rules = Analysis.getWordSet(env, settings, "keywords", this.version);
        if (rules == null) {
            throw new ElasticSearchIllegalArgumentException("keyword filter requires either `keywords` or `keywords_path` to be configured");
        }
        this.keywordLookup = new CharArraySet(this.version, (Collection)rules, ignoreCase);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new KeywordMarkerFilter(tokenStream, this.keywordLookup);
    }
}

