/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public class StandardHtmlStripAnalyzer
extends StopwordAnalyzerBase {
    public StandardHtmlStripAnalyzer(Version version) {
        super(version, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        final StandardTokenizer src = new StandardTokenizer(this.matchVersion, reader);
        src.setMaxTokenLength(255);
        StandardFilter tok = new StandardFilter(this.matchVersion, (TokenStream)src);
        tok = new LowerCaseFilter(this.matchVersion, (TokenStream)tok);
        tok = new StopFilter(this.matchVersion, (TokenStream)tok, (Set)this.stopwords);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)src, (TokenStream)tok){

            protected boolean reset(Reader reader) throws IOException {
                src.setMaxTokenLength(255);
                return super.reset(reader);
            }
        };
    }
}

