/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.query.QueryParseContext;

public interface FieldMapper<T> {
    public Names names();

    public Field.Index index();

    public boolean indexed();

    public boolean analyzed();

    public Field.Store store();

    public boolean stored();

    public Field.TermVector termVector();

    public float boost();

    public boolean omitNorms();

    public boolean omitTermFreqAndPositions();

    public Analyzer indexAnalyzer();

    public Analyzer searchAnalyzer();

    public Analyzer searchQuoteAnalyzer();

    public Object valueForSearch(Fieldable var1);

    public T value(Fieldable var1);

    public T valueFromString(String var1);

    public String valueAsString(Fieldable var1);

    public String indexedValue(String var1);

    public boolean useFieldQueryWithQueryString();

    public Query fieldQuery(String var1, @Nullable QueryParseContext var2);

    public Query fuzzyQuery(String var1, String var2, int var3, int var4);

    public Query fuzzyQuery(String var1, double var2, int var4, int var5);

    public Query prefixQuery(String var1, @Nullable MultiTermQuery.RewriteMethod var2, @Nullable QueryParseContext var3);

    public Filter prefixFilter(String var1, @Nullable QueryParseContext var2);

    public Query queryStringTermQuery(Term var1);

    public Filter fieldFilter(String var1, @Nullable QueryParseContext var2);

    public Query rangeQuery(String var1, String var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    public Filter rangeFilter(String var1, String var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    @Nullable
    public Filter nullValueFilter();

    public FieldDataType fieldDataType();

    public static class Names {
        private final String name;
        private final String indexName;
        private final String indexNameClean;
        private final String fullName;
        private final String sourcePath;
        private final Term indexNameTermFactory;

        public Names(String name) {
            this(name, name, name, name);
        }

        public Names(String name, String indexName, String indexNameClean, String fullName) {
            this(name, indexName, indexNameClean, fullName, fullName);
        }

        public Names(String name, String indexName, String indexNameClean, String fullName, @Nullable String sourcePath) {
            this.name = name.intern();
            this.indexName = indexName.intern();
            this.indexNameClean = indexNameClean.intern();
            this.fullName = fullName.intern();
            this.sourcePath = sourcePath == null ? this.fullName : sourcePath.intern();
            this.indexNameTermFactory = new Term(indexName, "");
        }

        public String name() {
            return this.name;
        }

        public String indexName() {
            return this.indexName;
        }

        public String indexNameClean() {
            return this.indexNameClean;
        }

        public String fullName() {
            return this.fullName;
        }

        public String sourcePath() {
            return this.sourcePath;
        }

        public Term indexNameTerm() {
            return this.indexNameTermFactory;
        }

        public Term createIndexNameTerm(String value) {
            return this.indexNameTermFactory.createTerm(value);
        }
    }
}

