/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.all.AllEntries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

public class ParseContext {
    private final DocumentMapper docMapper;
    private final DocumentMapperParser docMapperParser;
    private final ContentPath path;
    private XContentParser parser;
    private Document document;
    private List<Document> documents = new ArrayList<Document>();
    private Analyzer analyzer;
    private final String index;
    @Nullable
    private final Settings indexSettings;
    private SourceToParse sourceToParse;
    private byte[] source;
    private int sourceOffset;
    private int sourceLength;
    private String id;
    private DocumentMapper.ParseListener listener;
    private String uid;
    private StringBuilder stringBuilder = new StringBuilder();
    private Map<String, String> ignoredValues = new HashMap<String, String>();
    private boolean mappersAdded = false;
    private boolean externalValueSet;
    private Object externalValue;
    private AllEntries allEntries = new AllEntries();

    public ParseContext(String index, @Nullable Settings indexSettings, DocumentMapperParser docMapperParser, DocumentMapper docMapper, ContentPath path) {
        this.index = index;
        this.indexSettings = indexSettings;
        this.docMapper = docMapper;
        this.docMapperParser = docMapperParser;
        this.path = path;
    }

    public void reset(XContentParser parser, Document document, SourceToParse source, DocumentMapper.ParseListener listener) {
        this.parser = parser;
        this.document = document;
        if (document != null) {
            this.documents = new ArrayList<Document>();
            this.documents.add(document);
        } else {
            this.documents = null;
        }
        this.analyzer = null;
        this.uid = null;
        this.id = null;
        this.sourceToParse = source;
        this.source = source == null ? null : this.sourceToParse.source();
        this.sourceOffset = source == null ? 0 : this.sourceToParse.sourceOffset();
        this.sourceLength = source == null ? 0 : this.sourceToParse.sourceLength();
        this.path.reset();
        this.mappersAdded = false;
        this.listener = listener == null ? DocumentMapper.ParseListener.EMPTY : listener;
        this.allEntries = new AllEntries();
        this.ignoredValues.clear();
    }

    public boolean flyweight() {
        return this.sourceToParse.flyweight();
    }

    public DocumentMapperParser docMapperParser() {
        return this.docMapperParser;
    }

    public boolean mappersAdded() {
        return this.mappersAdded;
    }

    public void addedMapper() {
        this.mappersAdded = true;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public Settings indexSettings() {
        return this.indexSettings;
    }

    public String type() {
        return this.sourceToParse.type();
    }

    public SourceToParse sourceToParse() {
        return this.sourceToParse;
    }

    public byte[] source() {
        return this.source;
    }

    public int sourceOffset() {
        return this.sourceOffset;
    }

    public int sourceLength() {
        return this.sourceLength;
    }

    public void source(byte[] source, int offset, int length) {
        this.source = source;
        this.sourceOffset = offset;
        this.sourceLength = length;
    }

    public ContentPath path() {
        return this.path;
    }

    public XContentParser parser() {
        return this.parser;
    }

    public DocumentMapper.ParseListener listener() {
        return this.listener;
    }

    public Document rootDoc() {
        return this.documents.get(0);
    }

    public List<Document> docs() {
        return this.documents;
    }

    public Document doc() {
        return this.document;
    }

    public void addDoc(Document doc) {
        this.documents.add(doc);
    }

    public Document switchDoc(Document doc) {
        Document prev = this.document;
        this.document = doc;
        return prev;
    }

    public RootObjectMapper root() {
        return this.docMapper.root();
    }

    public DocumentMapper docMapper() {
        return this.docMapper;
    }

    public AnalysisService analysisService() {
        return this.docMapperParser.analysisService;
    }

    public String id() {
        return this.id;
    }

    public void ignoredValue(String indexName, String value) {
        this.ignoredValues.put(indexName, value);
    }

    public String ignoredValue(String indexName) {
        return this.ignoredValues.get(indexName);
    }

    public void id(String id) {
        this.id = id;
    }

    public String uid() {
        return this.uid;
    }

    public void uid(String uid) {
        this.uid = uid;
    }

    public boolean includeInAll(Boolean includeInAll, FieldMapper mapper) {
        return this.includeInAll(includeInAll, mapper.index());
    }

    private boolean includeInAll(Boolean specificIncludeInAll, Field.Index index) {
        if (!this.docMapper.allFieldMapper().enabled()) {
            return false;
        }
        if (specificIncludeInAll == null) {
            return index != Field.Index.NO;
        }
        return specificIncludeInAll;
    }

    public AllEntries allEntries() {
        return this.allEntries;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    public void analyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void externalValue(Object externalValue) {
        this.externalValueSet = true;
        this.externalValue = externalValue;
    }

    public boolean externalValueSet() {
        return this.externalValueSet;
    }

    public Object externalValue() {
        this.externalValueSet = false;
        return this.externalValue;
    }

    public StringBuilder stringBuilder() {
        this.stringBuilder.setLength(0);
        return this.stringBuilder;
    }
}

