/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.AndFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class AndFilterParser
implements FilterParser {
    public static final String NAME = "and";

    @Inject
    public AndFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        ArrayList<Filter> filters = Lists.newArrayList();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        String currentFieldName = null;
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                filters.add(parseContext.parseInnerFilter());
            }
        } else {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if ("filters".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            filters.add(parseContext.parseInnerFilter());
                        }
                        continue;
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        filters.add(parseContext.parseInnerFilter());
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("_cache".equals(currentFieldName)) {
                    cache = parser.booleanValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    filterName = parser.text();
                    continue;
                }
                if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                    cacheKey = new CacheKeyFilter.Key(parser.text());
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[and] filter does not support [" + currentFieldName + "]");
            }
        }
        if (filters.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "[and] filter requires 'filters' to be set on it'");
        }
        AndFilter filter = new AndFilter(filters);
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

