/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class ConstantScoreQueryParser
implements QueryParser {
    public static final String NAME = "constant_score";

    @Inject
    public ConstantScoreQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Filter filter = null;
        ConstantScoreQuery query = null;
        float boost = 1.0f;
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("filter".equals(currentFieldName)) {
                    filter = parseContext.parseInnerFilter();
                    continue;
                }
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[constant_score] query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[constant_score] query does not support [" + currentFieldName + "]");
        }
        if (filter == null && query == null) {
            throw new QueryParsingException(parseContext.index(), "[constant_score] requires either 'filter' or 'query' element");
        }
        if (filter != null) {
            if (cache) {
                filter = parseContext.cacheFilter(filter, cacheKey);
            }
            DeletionAwareConstantScoreQuery query1 = new DeletionAwareConstantScoreQuery(filter);
            query1.setBoost(boost);
            return query1;
        }
        query = new ConstantScoreQuery(query);
        query.setBoost(boost);
        return query;
    }
}

