/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.queryParser.MapperQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserSettings;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class FieldQueryParser
implements QueryParser {
    public static final String NAME = "field";
    private final boolean defaultAnalyzeWildcard;
    private final boolean defaultAllowLeadingWildcard;

    @Inject
    public FieldQueryParser(Settings settings) {
        this.defaultAnalyzeWildcard = settings.getAsBoolean("indices.query.query_string.analyze_wildcard", false);
        this.defaultAllowLeadingWildcard = settings.getAsBoolean("indices.query.query_string.allowLeadingWildcard", true);
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[field] query malformed, no field");
        }
        String fieldName = parser.currentName();
        QueryParserSettings qpSettings = new QueryParserSettings();
        qpSettings.defaultField(fieldName);
        qpSettings.analyzeWildcard(this.defaultAnalyzeWildcard);
        qpSettings.allowLeadingWildcard(this.defaultAllowLeadingWildcard);
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                NamedAnalyzer analyzer;
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (!token.isValue()) continue;
                if ("query".equals(currentFieldName)) {
                    qpSettings.queryString(parser.text());
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    qpSettings.boost(parser.floatValue());
                    continue;
                }
                if ("enable_position_increments".equals(currentFieldName) || "enablePositionIncrements".equals(currentFieldName)) {
                    qpSettings.enablePositionIncrements(parser.booleanValue());
                    continue;
                }
                if ("allow_leading_wildcard".equals(currentFieldName) || "allowLeadingWildcard".equals(currentFieldName)) {
                    qpSettings.allowLeadingWildcard(parser.booleanValue());
                    continue;
                }
                if ("auto_generate_phrase_queries".equals(currentFieldName) || "autoGeneratePhraseQueries".equals(currentFieldName)) {
                    qpSettings.autoGeneratePhraseQueries(parser.booleanValue());
                    continue;
                }
                if ("lowercase_expanded_terms".equals(currentFieldName) || "lowercaseExpandedTerms".equals(currentFieldName)) {
                    qpSettings.lowercaseExpandedTerms(parser.booleanValue());
                    continue;
                }
                if ("phrase_slop".equals(currentFieldName) || "phraseSlop".equals(currentFieldName)) {
                    qpSettings.phraseSlop(parser.intValue());
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    analyzer = parseContext.analysisService().analyzer(parser.text());
                    if (analyzer == null) {
                        throw new QueryParsingException(parseContext.index(), "[query_string] analyzer [" + parser.text() + "] not found");
                    }
                    qpSettings.forcedAnalyzer(analyzer);
                    continue;
                }
                if ("quote_analyzer".equals(currentFieldName) || "quoteAnalyzer".equals(currentFieldName)) {
                    analyzer = parseContext.analysisService().analyzer(parser.text());
                    if (analyzer == null) {
                        throw new QueryParsingException(parseContext.index(), "[query_string] analyzer [" + parser.text() + "] not found");
                    }
                    qpSettings.forcedQuoteAnalyzer(analyzer);
                    continue;
                }
                if ("default_operator".equals(currentFieldName) || "defaultOperator".equals(currentFieldName)) {
                    String op = parser.text();
                    if ("or".equalsIgnoreCase(op)) {
                        qpSettings.defaultOperator(QueryParser.Operator.OR);
                        continue;
                    }
                    if ("and".equalsIgnoreCase(op)) {
                        qpSettings.defaultOperator(QueryParser.Operator.AND);
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "Query default operator [" + op + "] is not allowed");
                }
                if ("fuzzy_min_sim".equals(currentFieldName) || "fuzzyMinSim".equals(currentFieldName)) {
                    qpSettings.fuzzyMinSim(parser.floatValue());
                    continue;
                }
                if ("fuzzy_prefix_length".equals(currentFieldName) || "fuzzyPrefixLength".equals(currentFieldName)) {
                    qpSettings.fuzzyPrefixLength(parser.intValue());
                    continue;
                }
                if ("fuzzy_max_expansions".equals(currentFieldName) || "fuzzyMaxExpansions".equals(currentFieldName)) {
                    qpSettings.fuzzyMaxExpansions(parser.intValue());
                    continue;
                }
                if ("fuzzy_rewrite".equals(currentFieldName) || "fuzzyRewrite".equals(currentFieldName)) {
                    qpSettings.fuzzyRewriteMethod(QueryParsers.parseRewriteMethod(parser.textOrNull()));
                    continue;
                }
                if ("escape".equals(currentFieldName)) {
                    qpSettings.escape(parser.booleanValue());
                    continue;
                }
                if ("analyze_wildcard".equals(currentFieldName) || "analyzeWildcard".equals(currentFieldName)) {
                    qpSettings.analyzeWildcard(parser.booleanValue());
                    continue;
                }
                if ("rewrite".equals(currentFieldName)) {
                    qpSettings.rewriteMethod(QueryParsers.parseRewriteMethod(parser.textOrNull()));
                    continue;
                }
                if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                    qpSettings.minimumShouldMatch(parser.textOrNull());
                    continue;
                }
                if ("quote_field_suffix".equals(currentFieldName) || "quoteFieldSuffix".equals(currentFieldName)) {
                    qpSettings.quoteFieldSuffix(parser.textOrNull());
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[field] query does not support [" + currentFieldName + "]");
            }
            parser.nextToken();
        } else {
            qpSettings.queryString(parser.text());
            parser.nextToken();
        }
        qpSettings.defaultAnalyzer(parseContext.mapperService().searchAnalyzer());
        qpSettings.defaultQuoteAnalyzer(parseContext.mapperService().searchQuoteAnalyzer());
        if (qpSettings.queryString() == null) {
            throw new QueryParsingException(parseContext.index(), "No value specified for term query");
        }
        if (qpSettings.escape()) {
            qpSettings.queryString(org.apache.lucene.queryParser.QueryParser.escape((String)qpSettings.queryString()));
        }
        if ((query = parseContext.indexCache().queryParserCache().get(qpSettings)) != null) {
            return query;
        }
        MapperQueryParser queryParser = parseContext.queryParser(qpSettings);
        try {
            query = queryParser.parse(qpSettings.queryString());
            query.setBoost(qpSettings.boost());
            query = Queries.optimizeQuery(Queries.fixNegativeQueryIfNeeded(query));
            if (query instanceof BooleanQuery) {
                Queries.applyMinimumShouldMatch((BooleanQuery)query, qpSettings.minimumShouldMatch());
            }
            parseContext.indexCache().queryParserCache().put(qpSettings, query);
            return query;
        }
        catch (ParseException e) {
            throw new QueryParsingException(parseContext.index(), "Failed to parse query [" + qpSettings.queryString() + "]", e);
        }
    }
}

