/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;

public class NumericRangeFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private Object from;
    private Object to;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private Boolean cache;
    private String cacheKey;
    private String filterName;

    public NumericRangeFilterBuilder(String name) {
        this.name = name;
    }

    public NumericRangeFilterBuilder from(Object from) {
        this.from = from;
        return this;
    }

    public NumericRangeFilterBuilder from(int from) {
        this.from = from;
        return this;
    }

    public NumericRangeFilterBuilder from(long from) {
        this.from = from;
        return this;
    }

    public NumericRangeFilterBuilder from(float from) {
        this.from = Float.valueOf(from);
        return this;
    }

    public NumericRangeFilterBuilder from(double from) {
        this.from = from;
        return this;
    }

    public NumericRangeFilterBuilder gt(Object from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public NumericRangeFilterBuilder gt(int from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public NumericRangeFilterBuilder gt(long from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public NumericRangeFilterBuilder gt(float from) {
        this.from = Float.valueOf(from);
        this.includeLower = false;
        return this;
    }

    public NumericRangeFilterBuilder gt(double from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public NumericRangeFilterBuilder gte(Object from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public NumericRangeFilterBuilder gte(int from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public NumericRangeFilterBuilder gte(long from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public NumericRangeFilterBuilder gte(float from) {
        this.from = Float.valueOf(from);
        this.includeLower = true;
        return this;
    }

    public NumericRangeFilterBuilder gte(double from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public NumericRangeFilterBuilder to(Object to) {
        this.to = to;
        return this;
    }

    public NumericRangeFilterBuilder to(int to) {
        this.to = to;
        return this;
    }

    public NumericRangeFilterBuilder to(long to) {
        this.to = to;
        return this;
    }

    public NumericRangeFilterBuilder to(float to) {
        this.to = Float.valueOf(to);
        return this;
    }

    public NumericRangeFilterBuilder to(double to) {
        this.to = to;
        return this;
    }

    public NumericRangeFilterBuilder lt(Object to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public NumericRangeFilterBuilder lt(int to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public NumericRangeFilterBuilder lt(long to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public NumericRangeFilterBuilder lt(float to) {
        this.to = Float.valueOf(to);
        this.includeUpper = false;
        return this;
    }

    public NumericRangeFilterBuilder lt(double to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public NumericRangeFilterBuilder lte(Object to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public NumericRangeFilterBuilder lte(int to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public NumericRangeFilterBuilder lte(long to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public NumericRangeFilterBuilder lte(float to) {
        this.to = Float.valueOf(to);
        this.includeUpper = true;
        return this;
    }

    public NumericRangeFilterBuilder lte(double to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public NumericRangeFilterBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public NumericRangeFilterBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public NumericRangeFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public NumericRangeFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public NumericRangeFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("numeric_range");
        builder.startObject(this.name);
        builder.field("from", this.from);
        builder.field("to", this.to);
        builder.field("include_lower", this.includeLower);
        builder.field("include_upper", this.includeUpper);
        builder.endObject();
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        builder.endObject();
    }
}

