/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class TermQueryParser
implements QueryParser {
    public static final String NAME = "term";

    @Inject
    public TermQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[term] query malformed, no field");
        }
        String fieldName = parser.currentName();
        String value = null;
        float boost = 1.0f;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (NAME.equals(currentFieldName)) {
                    value = parser.text();
                    continue;
                }
                if ("value".equals(currentFieldName)) {
                    value = parser.text();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[term] query does not support [" + currentFieldName + "]");
            }
            parser.nextToken();
        } else {
            value = parser.text();
            parser.nextToken();
        }
        if (value == null) {
            throw new QueryParsingException(parseContext.index(), "No value specified for term query");
        }
        TermQuery query = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                String[] previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                try {
                    query = smartNameFieldMappers.mapper().fieldQuery(value, parseContext);
                }
                finally {
                    QueryParseContext.setTypes(previousTypes);
                }
            } else {
                query = smartNameFieldMappers.mapper().fieldQuery(value, parseContext);
            }
        }
        if (query == null) {
            query = new TermQuery(new Term(fieldName, value));
        }
        query.setBoost(boost);
        return QueryParsers.wrapSmartNameQuery(query, smartNameFieldMappers, parseContext);
    }
}

