/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.nested;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.docset.FixedBitDocSet;

public class IncludeAllChildrenQuery
extends Query {
    private final Filter parentFilter;
    private final Query parentQuery;
    private final Query origParentQuery;

    public IncludeAllChildrenQuery(Query parentQuery, Filter parentFilter) {
        this.origParentQuery = parentQuery;
        this.parentQuery = parentQuery;
        this.parentFilter = parentFilter;
    }

    IncludeAllChildrenQuery(Query origParentQuery, Query parentQuery, Filter parentFilter) {
        this.origParentQuery = origParentQuery;
        this.parentQuery = parentQuery;
        this.parentFilter = parentFilter;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new IncludeAllChildrenWeight(this.parentQuery, this.parentQuery.createWeight(searcher), this.parentFilter);
    }

    public void extractTerms(Set<Term> terms) {
        this.parentQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query parentRewrite = this.parentQuery.rewrite(reader);
        if (parentRewrite != this.parentQuery) {
            IncludeAllChildrenQuery rewritten = new IncludeAllChildrenQuery(this.parentQuery, parentRewrite, this.parentFilter);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    public String toString(String field) {
        return "IncludeAllChildrenQuery (" + this.parentQuery.toString() + ")";
    }

    public boolean equals(Object _other) {
        if (_other instanceof IncludeAllChildrenQuery) {
            IncludeAllChildrenQuery other = (IncludeAllChildrenQuery)((Object)_other);
            return this.origParentQuery.equals((Object)other.origParentQuery) && this.parentFilter.equals(other.parentFilter);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + this.origParentQuery.hashCode();
        hash = 31 * hash + this.parentFilter.hashCode();
        return hash;
    }

    public Object clone() {
        return new IncludeAllChildrenQuery((Query)this.origParentQuery.clone(), this.parentFilter);
    }

    static class IncludeAllChildrenScorer
    extends Scorer {
        private final Scorer parentScorer;
        private final FixedBitSet parentBits;
        private int currentChildPointer = -1;
        private int currentParentPointer = -1;
        private int currentDoc = -1;

        IncludeAllChildrenScorer(Weight weight, Scorer parentScorer, FixedBitSet parentBits, int currentParentPointer) {
            super(weight);
            this.parentScorer = parentScorer;
            this.parentBits = parentBits;
            this.currentParentPointer = currentParentPointer;
            if (currentParentPointer == 0) {
                this.currentChildPointer = 0;
            } else {
                this.currentChildPointer = parentBits.prevSetBit(currentParentPointer - 1);
                this.currentChildPointer = this.currentChildPointer == -1 ? 0 : ++this.currentChildPointer;
            }
            this.currentDoc = this.currentChildPointer;
        }

        protected void visitSubScorers(Query parent, BooleanClause.Occur relationship, Scorer.ScorerVisitor<Query, Query, Scorer> visitor) {
            super.visitSubScorers(parent, relationship, visitor);
            this.parentScorer.visitScorers(visitor);
        }

        public int nextDoc() throws IOException {
            if (this.currentParentPointer == Integer.MAX_VALUE) {
                this.currentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.currentChildPointer == this.currentParentPointer) {
                this.currentDoc = this.currentParentPointer;
                this.currentParentPointer = this.parentScorer.nextDoc();
                if (this.currentParentPointer != Integer.MAX_VALUE) {
                    this.currentChildPointer = this.parentBits.prevSetBit(this.currentParentPointer - 1);
                    this.currentChildPointer = this.currentChildPointer == -1 ? this.currentParentPointer : ++this.currentChildPointer;
                }
            } else {
                this.currentDoc = this.currentChildPointer++;
            }
            assert (this.currentDoc != -1);
            return this.currentDoc;
        }

        public int advance(int target) throws IOException {
            if (target == Integer.MAX_VALUE) {
                this.currentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (target == 0) {
                return this.nextDoc();
            }
            this.currentParentPointer = this.parentScorer.advance(target);
            if (this.currentParentPointer == Integer.MAX_VALUE) {
                this.currentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.currentParentPointer == 0) {
                this.currentChildPointer = 0;
            } else {
                this.currentChildPointer = this.parentBits.prevSetBit(this.currentParentPointer - 1);
                this.currentChildPointer = this.currentChildPointer == -1 ? 0 : ++this.currentChildPointer;
            }
            this.currentDoc = this.currentChildPointer;
            return this.currentDoc;
        }

        public float score() throws IOException {
            return this.parentScorer.score();
        }

        public int docID() {
            return this.currentDoc;
        }
    }

    static class IncludeAllChildrenWeight
    extends Weight {
        private final Query parentQuery;
        private final Weight parentWeight;
        private final Filter parentsFilter;

        IncludeAllChildrenWeight(Query parentQuery, Weight parentWeight, Filter parentsFilter) {
            this.parentQuery = parentQuery;
            this.parentWeight = parentWeight;
            this.parentsFilter = parentsFilter;
        }

        public Query getQuery() {
            return this.parentQuery;
        }

        public float getValue() {
            return this.parentWeight.getValue();
        }

        public float sumOfSquaredWeights() throws IOException {
            return this.parentWeight.sumOfSquaredWeights() * this.parentQuery.getBoost() * this.parentQuery.getBoost();
        }

        public void normalize(float norm) {
            this.parentWeight.normalize(norm * this.parentQuery.getBoost());
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer parentScorer = this.parentWeight.scorer(reader, true, false);
            if (parentScorer == null) {
                return null;
            }
            int firstParentDoc = parentScorer.nextDoc();
            if (firstParentDoc == Integer.MAX_VALUE) {
                return null;
            }
            DocIdSet parents = this.parentsFilter.getDocIdSet(reader);
            if (parents == null) {
                return null;
            }
            if (parents instanceof FixedBitDocSet) {
                parents = ((FixedBitDocSet)parents).set();
            }
            if (!(parents instanceof FixedBitSet)) {
                throw new IllegalStateException("parentFilter must return OpenBitSet; got " + parents);
            }
            return new IncludeAllChildrenScorer(this, parentScorer, (FixedBitSet)parents, firstParentDoc);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return null;
        }

        public boolean scoresDocsOutOfOrder() {
            return false;
        }
    }
}

